/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.jni;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContextFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;

public abstract class GraalHPyJNIConvertArgNode
extends Node {
    private static final GraalHPyJNIConvertArgUncachedNode UNCACHED = new GraalHPyJNIConvertArgUncachedNode();

    @NeverDefault
    public static GraalHPyJNIConvertArgNode create(GraalHPyContext.LLVMType signature) {
        return new GraalHPyJNIConvertArgCachedNode();
    }

    public static GraalHPyJNIConvertArgNode getUncached(GraalHPyContext.LLVMType signature) {
        return UNCACHED;
    }

    public abstract long execute(Object[] var1, int var2);

    protected static GraalHPyJNIContext getHPyContext(Object[] arguments) {
        Object backend = arguments[0];
        if (backend instanceof GraalHPyJNIContext) {
            GraalHPyJNIContext jniBackend = (GraalHPyJNIContext)backend;
            return jniBackend;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"first argument is expected to the HPy context");
    }

    static final class GraalHPyJNIConvertArgCachedNode
    extends GraalHPyJNIConvertArgNode {
        private static final int CACHE_LIMIT = 4;
        @Node.Child
        private InteropLibrary interopLibrary;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile profile;
        @Node.Child
        GraalHPyContext.GetHPyHandleForSingleton getHPyHandleForSingleton;

        GraalHPyJNIConvertArgCachedNode() {
        }

        @Override
        public long execute(Object[] arguments, int i) {
            CompilerAsserts.partialEvaluationConstant((int)i);
            Object value = arguments[i];
            if (value instanceof GraalHPyHandle) {
                GraalHPyHandle handle = (GraalHPyHandle)value;
                Object delegate = handle.getDelegate();
                if (GraalHPyBoxing.isBoxablePrimitive(delegate)) {
                    if (delegate instanceof Integer) {
                        return GraalHPyBoxing.boxInt((Integer)delegate);
                    }
                    assert (delegate instanceof Double);
                    return GraalHPyBoxing.boxDouble((Double)delegate);
                }
                return handle.getId(GraalHPyJNIConvertArgCachedNode.getHPyContext(arguments).getHPyContext(), this.ensureProfile(), this.ensureHandleForSingletonNode());
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (this.interopLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(4)));
            }
            if (!this.interopLibrary.isPointer(value)) {
                this.interopLibrary.toNative(value);
            }
            try {
                return this.interopLibrary.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        private ConditionProfile ensureProfile() {
            if (this.profile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.profile = ConditionProfile.create();
            }
            return this.profile;
        }

        private GraalHPyContext.GetHPyHandleForSingleton ensureHandleForSingletonNode() {
            if (this.getHPyHandleForSingleton == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getHPyHandleForSingleton = (GraalHPyContext.GetHPyHandleForSingleton)this.insert(GraalHPyContextFactory.GetHPyHandleForSingletonNodeGen.create());
            }
            return this.getHPyHandleForSingleton;
        }
    }

    static final class GraalHPyJNIConvertArgUncachedNode
    extends GraalHPyJNIConvertArgNode {
        GraalHPyJNIConvertArgUncachedNode() {
        }

        @Override
        public long execute(Object[] arguments, int i) {
            Object value = arguments[i];
            if (value instanceof GraalHPyHandle) {
                GraalHPyHandle handle = (GraalHPyHandle)value;
                Object delegate = handle.getDelegate();
                if (GraalHPyBoxing.isBoxablePrimitive(delegate)) {
                    if (delegate instanceof Integer) {
                        return GraalHPyBoxing.boxInt((Integer)delegate);
                    }
                    assert (delegate instanceof Double);
                    return GraalHPyBoxing.boxDouble((Double)delegate);
                }
                return handle.getIdUncached(GraalHPyJNIConvertArgUncachedNode.getHPyContext(arguments).getHPyContext());
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            InteropLibrary interopLibrary = InteropLibrary.getUncached((Object)value);
            if (!interopLibrary.isPointer(value)) {
                interopLibrary.toNative(value);
            }
            try {
                return interopLibrary.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }
}

