/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.types.GenericAliasBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.types.GenericAliasBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGenericAlias})
public final class GenericAliasBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GenericAliasBuiltinsSlotsGen.SLOTS;
    private static final TruffleString[] ATTR_EXCEPTIONS = new TruffleString[]{SpecialAttributeNames.T___CLASS__, SpecialAttributeNames.T___ORIGIN__, SpecialAttributeNames.T___ARGS__, SpecialAttributeNames.T___UNPACKED__, SpecialAttributeNames.T___PARAMETERS__, GenericTypeNodes.T___TYPING_UNPACKED_TUPLE_ARGS__, SpecialMethodNames.T___MRO_ENTRIES__, SpecialMethodNames.T___REDUCE_EX__, SpecialMethodNames.T___REDUCE__, SpecialMethodNames.T___COPY__, SpecialMethodNames.T___DEEPCOPY__};

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GenericAliasBuiltinsFactory.getFactories();
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object iter(PGenericAlias self, @Cached PythonObjectFactory factory) {
            return factory.createGenericAliasIterator(self);
        }
    }

    @Builtin(name="__typing_unpacked_tuple_args__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class TypingUnpackedTupleArgsNode
    extends PythonUnaryBuiltinNode {
        TypingUnpackedTupleArgsNode() {
        }

        @Specialization
        static Object get(PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameTypeNode) {
            if (self.isStarred() && isSameTypeNode.execute(inliningTarget, self.getOrigin(), (Object)PythonBuiltinClassType.PTuple)) {
                return self.getArgs();
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        GetItemNode() {
        }

        @Specialization
        static Object getitem(PGenericAlias self, Object item, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory) {
            if (self.getParameters() == null) {
                self.setParameters(factory.createTuple(GenericTypeNodes.makeParameters(self.getArgs())));
            }
            Object[] newargs = GenericTypeNodes.subsParameters(inliningTarget, self, self.getArgs(), self.getParameters(), item);
            PTuple newargsTuple = factory.createTuple(newargs);
            return factory.createGenericAlias(self.getOrigin(), newargsTuple, self.isStarred());
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        DirNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object dir(PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached PyObjectDir dir, @Cached PySequenceContainsNode containsNode, @Cached ListNodes.AppendNode appendNode) {
            PList list = dir.execute(null, inliningTarget, self.getOrigin());
            for (int i = 0; i < ATTR_EXCEPTIONS.length; ++i) {
                if (containsNode.execute(null, inliningTarget, list, ATTR_EXCEPTIONS[i])) continue;
                appendNode.execute(list, ATTR_EXCEPTIONS[i]);
            }
            return list;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetIter getIter, @Cached PyObjectGetAttr getAttr, @Cached PythonObjectFactory factory) {
            if (self.isStarred()) {
                PGenericAlias copy = factory.createGenericAlias(self.getOrigin(), self.getArgs());
                PythonModule builtins = PythonContext.get(inliningTarget).getBuiltins();
                Object next = getAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_NEXT);
                PTuple args = factory.createTuple(new Object[]{getIter.execute((Frame)frame, inliningTarget, copy)});
                return factory.createTuple(new Object[]{next, args});
            }
            PTuple args = factory.createTuple(new Object[]{self.getOrigin(), self.getArgs()});
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }

    @Builtin(name="__subclasscheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubclassCheckNode
    extends PythonBinaryBuiltinNode {
        SubclassCheckNode() {
        }

        @Specialization
        static Object check(PGenericAlias self, Object other, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISSUBCLASS_ARG_2_CANNOT_BE_A_PARAMETERIZED_GENERIC);
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstanceCheckNode
    extends PythonBinaryBuiltinNode {
        InstanceCheckNode() {
        }

        @Specialization
        static Object check(PGenericAlias self, Object other, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISINSTANCE_ARG_2_CANNOT_BE_A_PARAMETERIZED_GENERIC);
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PGenericAlias self, Object bases, @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{self.getOrigin()});
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        static boolean eq(VirtualFrame frame, PGenericAlias self, PGenericAlias other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqOrigin, @Cached PyObjectRichCompareBool.EqNode eqArgs) {
            if (self.isStarred() != other.isStarred()) {
                return false;
            }
            return eqOrigin.compare((Frame)frame, inliningTarget, self.getOrigin(), other.getOrigin()) && eqArgs.compare((Frame)frame, inliningTarget, self.getArgs(), other.getArgs());
        }

        @Fallback
        static Object eq(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        @ExplodeLoop
        static Object getattribute(VirtualFrame frame, PGenericAlias self, Object nameObj, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached TruffleString.EqualNode equalNode, @Cached PyObjectGetAttr getAttr, @Cached ObjectBuiltins.GetAttributeNode genericGetAttribute) {
            TruffleString name;
            try {
                name = cast.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            for (int i = 0; i < ATTR_EXCEPTIONS.length; ++i) {
                if (!equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)ATTR_EXCEPTIONS[i], PythonUtils.TS_ENCODING)) continue;
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            return getAttr.execute((Frame)frame, inliningTarget, self.getOrigin(), name);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class CallMethodNode
    extends PythonVarargsBuiltinNode {
        CallMethodNode() {
        }

        @Specialization
        static Object call(VirtualFrame frame, PGenericAlias self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectSetAttr setAttr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile typeErrorProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attributeErrorProfile) {
            Object result;
            block2: {
                result = callNode.execute((Frame)frame, self.getOrigin(), args, kwargs);
                try {
                    setAttr.execute((Frame)frame, inliningTarget, result, SpecialAttributeNames.T___ORIG_CLASS__, self);
                }
                catch (PException e) {
                    if (typeErrorProfile.profileException(inliningTarget, e, PythonBuiltinClassType.TypeError) || attributeErrorProfile.profileException(inliningTarget, e, PythonBuiltinClassType.AttributeError)) break block2;
                    throw e;
                }
            }
            return result;
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long hash(VirtualFrame frame, PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashOrigin, @Cached PyObjectHashNode hashArgs) {
            long h0 = hashOrigin.execute((Frame)frame, inliningTarget, self.getOrigin());
            long h1 = hashArgs.execute((Frame)frame, inliningTarget, self.getArgs());
            return h0 ^ h1;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString SEPARATOR = PythonUtils.tsLiteral(", ");

        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object repr(PGenericAlias self) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            if (self.isStarred()) {
                sb.appendCodePointUncached(42);
            }
            ReprNode.reprItem(sb, self.getOrigin());
            sb.appendCodePointUncached(91);
            SequenceStorage argsStorage = self.getArgs().getSequenceStorage();
            for (int i = 0; i < argsStorage.length(); ++i) {
                if (i > 0) {
                    sb.appendStringUncached(SEPARATOR);
                }
                ReprNode.reprItem(sb, SequenceStorageNodes.GetItemScalarNode.executeUncached(argsStorage, i));
            }
            if (argsStorage.length() == 0) {
                sb.appendCodePointUncached(40);
                sb.appendCodePointUncached(41);
            }
            sb.appendCodePointUncached(93);
            return sb.toStringUncached();
        }

        private static void reprItem(TruffleStringBuilder sb, Object obj) {
            if (obj == PEllipsis.INSTANCE) {
                sb.appendStringUncached(StringLiterals.T_ELLIPSIS);
                return;
            }
            GenericTypeNodes.reprItem(sb, obj);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode orNode) {
            return orNode.execute(self, other);
        }
    }

    @Builtin(name="__unpacked__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnpackedNode
    extends PythonUnaryBuiltinNode {
        UnpackedNode() {
        }

        @Specialization
        static Object unpacked(PGenericAlias self) {
            return self.isStarred();
        }
    }

    @Builtin(name="__parameters__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ParametersNode
    extends PythonUnaryBuiltinNode {
        ParametersNode() {
        }

        @Specialization
        static Object parameters(PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory.Lazy factory) {
            if (self.getParameters() == null) {
                self.setParameters(factory.get(inliningTarget).createTuple(GenericTypeNodes.makeParameters(self.getArgs())));
            }
            return self.getParameters();
        }
    }

    @Builtin(name="__args__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ArgsNode
    extends PythonUnaryBuiltinNode {
        ArgsNode() {
        }

        @Specialization
        static Object args(PGenericAlias self) {
            return self.getArgs();
        }
    }

    @Builtin(name="__origin__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class OriginNode
    extends PythonUnaryBuiltinNode {
        OriginNode() {
        }

        @Specialization
        static Object origin(PGenericAlias self) {
            return self.getOrigin();
        }
    }
}

