/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectGetAttr
extends Node {
    public static Object executeUncached(Object receiver, TruffleString name) {
        return PyObjectGetAttr.getUncached().execute(null, null, receiver, name);
    }

    public final Object executeCached(Frame frame, Object receiver, TruffleString name) {
        return this.execute(frame, this, receiver, name);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, TruffleString var4);

    public final Object execute(Node inliningTarget, Object receiver, TruffleString name) {
        return this.execute(null, inliningTarget, receiver, name);
    }

    @Specialization(guards={"name == cachedName"}, limit="1")
    static Object getFixedAttr(VirtualFrame frame, Object receiver, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached(value="create(name)") GetAttributeNode.GetFixedAttributeNode getAttrNode) {
        return getAttrNode.execute(frame, receiver);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"getFixedAttr"})
    static Object getDynamicAttr(Frame frame, Node inliningTarget, Object receiver, TruffleString name, @Cached GetClassNode getClass, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TpSlotGetAttr.CallSlotGetAttrNode callGetAttrNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        Object result;
        Object type = getClass.execute(inliningTarget, receiver);
        TpSlots slots = getSlotsNode.execute(inliningTarget, receiver);
        if (!codePointLengthNode.isAdoptable() && (result = PyObjectLookupAttr.readAttributeQuickly(type, slots, receiver, name, codePointLengthNode, codePointAtIndexNode)) != null) {
            if (result == PNone.NO_VALUE) {
                throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, receiver, name);
            }
            return result;
        }
        return callGetAttrNode.execute((VirtualFrame)frame, inliningTarget, slots, receiver, name);
    }

    @NeverDefault
    public static PyObjectGetAttr create() {
        return PyObjectGetAttrNodeGen.create();
    }

    public static PyObjectGetAttr getUncached() {
        return PyObjectGetAttrNodeGen.getUncached();
    }
}

