/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={PGuards.class})
public abstract class PySequenceSizeNode
extends Node {
    public abstract int execute(Frame var1, Node var2, Object var3);

    @Specialization
    static int doTruffleString(TruffleString str, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode) {
        return codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
    }

    @Specialization(guards={"isBuiltinList(object)"})
    static int doList(PList object) {
        return object.getSequenceStorage().length();
    }

    @Specialization(guards={"isBuiltinTuple(object)"})
    static int doTuple(PTuple object) {
        return object.getSequenceStorage().length();
    }

    @Specialization(guards={"isBuiltinAnySet(object)"})
    static int doSet(Node inliningTarget, PBaseSet object, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage());
    }

    @Specialization(guards={"isBuiltinPString(object)"})
    @HostCompilerDirectives.InliningCutoff
    static int doPString(PString object, @Cached(inline=false) StringNodes.StringLenNode lenNode) {
        return lenNode.execute(object);
    }

    @Specialization(guards={"isBuiltinBytesLike(object)"})
    static int doPBytes(PBytesLike object) {
        return object.getSequenceStorage().length();
    }

    @Fallback
    static int doOthers(Frame frame, Node inliningTarget, Object object, @Cached TpSlots.GetObjectSlotsNode getTpSlotsNode, @Cached TpSlotLen.CallSlotLenNode callSlotLenNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        TpSlots slots = getTpSlotsNode.execute(inliningTarget, object);
        if (slots.sq_length() != null) {
            return callSlotLenNode.execute((VirtualFrame)frame, inliningTarget, slots.sq_length(), object);
        }
        throw PySequenceSizeNode.raiseError(object, inliningTarget, raiseNode, slots);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseError(Object object, Node inliningTarget, PRaiseNode.Lazy raiseNode, TpSlots slots) {
        TruffleString error = ErrorMessages.OBJ_HAS_NO_LEN;
        if (slots.mp_length() == null) {
            error = ErrorMessages.IS_NOT_A_SEQUENCE;
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, error, object);
    }
}

