/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.GetAwaitableNode;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.GetANextNodeGen;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@ImportStatic(value={SpecialMethodSlot.class})
@GenerateInline(value=false)
public abstract class GetANextNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2);

    public static GetANextNode getUncached() {
        return GetANextNodeGen.getUncached();
    }

    public static GetANextNode create() {
        return GetANextNodeGen.create();
    }

    @Specialization
    Object doGeneric(Frame frame, Object receiver, @Bind(value="this") Node inliningTarget, @Cached(parameters={"ANext"}) LookupSpecialMethodSlotNode getANext, @Cached GetClassNode getAsyncIterType, @Cached PRaiseNode raiseNoANext, @Cached InlinedBranchProfile errorProfile, @Cached CallUnaryMethodNode callANext, @Cached PRaiseNode raiseInvalidObject, @Cached(neverDefault=true) GetAwaitableNode getAwaitable) {
        Object type = getAsyncIterType.execute(inliningTarget, receiver);
        Object getter = getANext.execute(frame, type, receiver);
        if (getter == PNone.NO_VALUE) {
            errorProfile.enter(inliningTarget);
            throw raiseNoANext.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ASYNC_FOR_NO_ANEXT_ITERATION, receiver);
        }
        Object anext = callANext.executeObject(frame, getter, receiver);
        try {
            return getAwaitable.execute(frame, anext);
        }
        catch (PException e) {
            errorProfile.enter(inliningTarget);
            throw raiseInvalidObject.raiseWithCause(PythonBuiltinClassType.TypeError, e, ErrorMessages.ANEXT_INVALID_OBJECT, anext);
        }
    }
}

