/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.call.DirectInvokeNode;
import com.oracle.graal.python.nodes.call.FunctionInvokeNodeGen;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class FunctionInvokeNode
extends DirectInvokeNode {
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private ExecutionContext.CallContext callContext;
    private final PFunction callee;
    private final PythonObject globals;
    private final PCell[] closure;
    protected final boolean isBuiltin;

    protected FunctionInvokeNode(PFunction callee, CallTarget callTarget, PythonObject globals, PCell[] closure, boolean isBuiltin, boolean isGenerator, boolean split) {
        this.callee = callee;
        this.callNode = Truffle.getRuntime().createDirectCallNode(callTarget);
        if (split) {
            this.callNode.cloneCallTarget();
        }
        if (isGenerator && FunctionInvokeNode.shouldInlineGenerators()) {
            this.callNode.forceInlining();
        }
        this.globals = globals;
        this.closure = closure;
        this.isBuiltin = isBuiltin;
        this.callContext = ExecutionContext.CallContext.create();
    }

    public abstract Object execute(VirtualFrame var1, Object[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization
    protected Object doDirect(VirtualFrame frame, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        PArguments.setGlobals(arguments, this.globals);
        PArguments.setClosure(arguments, this.closure);
        RootCallTarget ct = (RootCallTarget)this.callNode.getCurrentCallTarget();
        FunctionInvokeNode.optionallySetGeneratorFunction(inliningTarget, arguments, (CallTarget)ct, isGeneratorFunctionProfile, this.callee);
        if (this.profileIsNullFrame(frame == null)) {
            PythonContext.PythonThreadState threadState = PythonContext.get(this).getThreadState(PythonLanguage.get(this));
            Object state = ExecutionContext.IndirectCalleeContext.enter(threadState, arguments, ct);
            try {
                Object object = this.callNode.call(arguments);
                return object;
            }
            finally {
                ExecutionContext.IndirectCalleeContext.exit(threadState, state);
            }
        }
        this.callContext.prepareCall(frame, arguments, ct, this);
        return this.callNode.call(arguments);
    }

    public final RootNode getCurrentRootNode() {
        return this.callNode.getCurrentRootNode();
    }

    @CompilerDirectives.TruffleBoundary
    public static FunctionInvokeNode create(PFunction callee) {
        RootCallTarget callTarget = FunctionInvokeNode.getCallTarget(callee);
        return FunctionInvokeNodeGen.create(callee, (CallTarget)callTarget, callee.getGlobals(), callee.getClosure(), false, callTarget.getRootNode() instanceof PBytecodeGeneratorFunctionRootNode, callee.forceSplitDirectCalls());
    }

    @CompilerDirectives.TruffleBoundary
    public static FunctionInvokeNode create(PBuiltinFunction callee) {
        BuiltinFunctionRootNode root;
        RootNode rootNode;
        RootCallTarget callTarget = FunctionInvokeNode.getCallTarget(callee);
        boolean split = FunctionInvokeNode.forceSplitBuiltins() || (rootNode = callee.getFunctionRootNode()) instanceof BuiltinFunctionRootNode && (root = (BuiltinFunctionRootNode)rootNode).getBuiltin().forceSplitDirectCalls();
        return FunctionInvokeNodeGen.create(null, (CallTarget)callTarget, null, null, true, false, split);
    }
}

