/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={MathGuards.class})
public abstract class CastToJavaByteNode
extends PNodeWithContext {
    public abstract byte execute(Node var1, byte var2);

    public abstract byte execute(Node var1, int var2);

    public abstract byte execute(Node var1, long var2);

    public abstract byte execute(Node var1, Object var2);

    @Specialization
    static byte fromByte(byte x) {
        return x;
    }

    @Specialization(rewriteOn={OverflowException.class})
    static byte fromInt(int x) throws OverflowException {
        return PInt.byteValueExact(x);
    }

    @Specialization(rewriteOn={OverflowException.class})
    static byte fromLong(long x) throws OverflowException {
        return PInt.byteValueExact(x);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    static byte fromPInt(PInt x) {
        return x.byteValueExact();
    }

    @Specialization(replaces={"fromInt"})
    @HostCompilerDirectives.InliningCutoff
    static byte fromIntErr(Node inliningTarget, int x, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
        try {
            return PInt.byteValueExact(x);
        }
        catch (OverflowException e) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
        }
    }

    @Specialization(replaces={"fromLong"})
    @HostCompilerDirectives.InliningCutoff
    static byte fromLongErr(Node inliningTarget, long x, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
        try {
            return PInt.byteValueExact(x);
        }
        catch (OverflowException e) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
        }
    }

    @Specialization(replaces={"fromPInt"})
    @HostCompilerDirectives.InliningCutoff
    static byte fromPIntErr(Node inliningTarget, PInt x, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
        try {
            return x.byteValueExact();
        }
        catch (ArithmeticException e) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
        }
    }
}

