/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class InternalFormat {
    @CompilerDirectives.TruffleBoundary
    public static Spec fromText(TruffleString text, char defaultType, char defaultAlignment, Node raisingNode) {
        Parser parser = new Parser(text.toJavaStringUncached());
        return parser.parse(defaultType, defaultAlignment, raisingNode);
    }

    private static class Parser {
        private final String spec;
        private int ptr;

        Parser(String spec) {
            this.spec = spec;
            this.ptr = 0;
        }

        Spec parse(char defaultType, char defaultAlignment, Node raisingNode) {
            char type = defaultType;
            char align = '\uffff';
            char fill = '\uffff';
            char sign = '\uffff';
            char grouping = '\uffff';
            int width = -1;
            int precision = -1;
            if (this.isAlign()) {
                align = this.spec.charAt(this.ptr++);
            } else {
                ++this.ptr;
                if (this.isAlign()) {
                    fill = this.spec.charAt(0);
                    align = this.spec.charAt(this.ptr++);
                } else {
                    this.ptr = 0;
                }
            }
            if (this.isAt("+- ")) {
                sign = this.spec.charAt(this.ptr++);
            }
            boolean alternate = this.scanPast('#');
            if (this.scanPast('0') && !Spec.specified(fill)) {
                fill = '0';
                if (!Spec.specified(align) && defaultAlignment == '>') {
                    align = '=';
                }
            }
            if (!Spec.specified(align)) {
                align = defaultAlignment;
            }
            if (this.isDigit()) {
                try {
                    width = this.scanInteger();
                }
                catch (NumberFormatException ex) {
                    throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.WIDTH_TOO_BIG);
                }
            }
            if (this.scanPast(',')) {
                grouping = ',';
            }
            if (this.scanPast('_')) {
                if (Spec.specified(grouping)) {
                    throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.CANNOT_SPECIFY_BOTH_COMMA_AND_UNDERSCORE);
                }
                grouping = '_';
                if (this.scanPast(',')) {
                    throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.CANNOT_SPECIFY_BOTH_COMMA_AND_UNDERSCORE);
                }
            }
            if (this.scanPast('.')) {
                if (this.isDigit()) {
                    try {
                        precision = this.scanInteger();
                    }
                    catch (NumberFormatException ex) {
                        throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.PRECISION_TOO_BIG);
                    }
                } else {
                    throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.FMT_SPECIFIER_MISSING_PRECISION);
                }
            }
            if (this.ptr < this.spec.length()) {
                type = this.spec.charAt(this.ptr++);
            }
            if (this.ptr != this.spec.length()) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.INVALID_CONVERSION_SPECIFICATION);
            }
            if (Spec.specified(grouping)) {
                if (!(switch (type) {
                    case '\u0000', '%', 'E', 'F', 'G', 'd', 'e', 'f', 'g', '\uffff' -> true;
                    case 'X', 'b', 'o', 'x' -> grouping == '_';
                    default -> false;
                })) {
                    throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.CANNOT_SPECIFY_C_WITH_C, Character.valueOf(grouping), Character.valueOf(type));
                }
            }
            return new Spec(fill, align, sign, alternate, width, grouping, precision, type);
        }

        private boolean scanPast(char c) {
            if (this.ptr < this.spec.length() && this.spec.charAt(this.ptr) == c) {
                ++this.ptr;
                return true;
            }
            return false;
        }

        private boolean isAt(String chars) {
            return this.ptr < this.spec.length() && chars.indexOf(this.spec.charAt(this.ptr)) >= 0;
        }

        private boolean isAlign() {
            return this.ptr < this.spec.length() && "<^>=".indexOf(this.spec.charAt(this.ptr)) >= 0;
        }

        private boolean isDigit() {
            return this.ptr < this.spec.length() && Character.isDigit(this.spec.charAt(this.ptr));
        }

        private int scanInteger() throws NumberFormatException {
            int p = this.ptr++;
            while (this.isDigit()) {
                ++this.ptr;
            }
            return Integer.parseInt(this.spec.substring(p, this.ptr));
        }
    }

    public static class Spec {
        public final char fill;
        public final char align;
        public final char sign;
        public final boolean alternate;
        public final int width;
        public final char grouping;
        public final int precision;
        public final char type;
        public static final char NONE = '\uffff';
        public static final int UNSPECIFIED = -1;

        public static boolean specified(char c) {
            return c != '\uffff';
        }

        public static boolean specified(int value) {
            return value >= 0;
        }

        public Spec(char fill, char align, char sign, boolean alternate, int width, char grouping, int precision, char type) {
            this.fill = fill;
            this.align = align;
            this.sign = sign;
            this.alternate = alternate;
            this.width = width;
            this.grouping = grouping;
            this.precision = precision;
            this.type = type;
        }

        public String toString() {
            FormattingBuffer.StringFormattingBuffer buf = new FormattingBuffer.StringFormattingBuffer();
            if (Spec.specified(this.fill)) {
                buf.append(this.fill);
            }
            if (Spec.specified(this.align)) {
                buf.append(this.align);
            }
            if (Spec.specified(this.sign)) {
                buf.append(this.sign);
            }
            if (this.alternate) {
                buf.append('#');
            }
            if (Spec.specified(this.width)) {
                buf.append(this.width);
            }
            if (Spec.specified(this.grouping)) {
                buf.append(this.grouping);
            }
            if (Spec.specified(this.precision)) {
                buf.append('.').append(this.precision);
            }
            if (Spec.specified(this.type)) {
                buf.append(this.type);
            }
            return buf.toString();
        }

        public Spec(int precision, char type) {
            this(' ', '>', '\uffff', false, -1, '\uffff', precision, type);
        }

        public char getFill(char defaultFill) {
            return Spec.specified(this.fill) ? this.fill : defaultFill;
        }

        public char getAlign(char defaultAlign) {
            return Spec.specified(this.align) ? this.align : defaultAlign;
        }

        public int getPrecision(int defaultPrecision) {
            return Spec.specified(this.precision) ? this.precision : defaultPrecision;
        }

        public char getType(char defaultType) {
            return Spec.specified(this.type) ? this.type : defaultType;
        }

        public int getGroupingSize() {
            if (!Spec.specified(this.grouping)) {
                return -1;
            }
            switch (this.type) {
                case 'X': 
                case 'b': 
                case 'o': 
                case 'x': {
                    assert (this.grouping == '_');
                    return 4;
                }
            }
            return 3;
        }
    }

    public static class Formatter
    implements Appendable {
        protected final Node raisingNode;
        protected final Spec spec;
        protected final FormattingBuffer result;
        protected boolean bytes;
        protected final int mark;
        protected int start;
        protected int lenSign;
        protected int lenWhole;
        protected char actualGrouping;
        protected int actualGroupSize;

        protected Formatter(FormattingBuffer result, Spec spec, Node raisingNode) {
            this.raisingNode = raisingNode;
            this.spec = spec;
            this.result = result;
            this.start = this.mark = result.length();
        }

        public void setBytes(boolean bytes) {
            this.bytes = bytes;
        }

        public TruffleString getResult() {
            return PythonUtils.toTruffleStringUncached(this.result.toString());
        }

        @Override
        public Formatter append(char c) {
            this.result.append(c);
            return this;
        }

        @Override
        public Formatter append(CharSequence csq) {
            this.result.append(csq);
            return this;
        }

        @Override
        public Formatter append(CharSequence csq, int begin, int end) throws IndexOutOfBoundsException {
            this.result.append(csq, begin, end);
            return this;
        }

        public void setStart() {
            this.start = this.result.length();
            this.actualGrouping = this.spec.grouping;
            this.actualGroupSize = this.spec.getGroupingSize();
            if (this.start > this.mark) {
                this.reset();
            }
        }

        protected void reset() {
            this.lenWhole = 0;
            this.lenSign = 0;
        }

        protected int[] sectionLengths() {
            return new int[]{this.lenSign, this.lenWhole};
        }

        public String toString() {
            if (this.result == null) {
                return "[]";
            }
            FormattingBuffer.StringFormattingBuffer buf = new FormattingBuffer.StringFormattingBuffer(this.result.length() + 20);
            buf.append(this.result);
            try {
                int p = this.start;
                buf.insert(p++, '[');
                for (int len : this.sectionLengths()) {
                    p += len;
                    buf.insert(p++, '|');
                }
                buf.setCharAt(p - 1, ']');
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return buf.toString();
        }

        protected static DecimalFormat getCurrentDecimalFormat() {
            Locale currLocale = Locale.getDefault(Locale.Category.FORMAT);
            NumberFormat numberFormat = NumberFormat.getInstance(currLocale);
            return numberFormat instanceof DecimalFormat ? (DecimalFormat)numberFormat : null;
        }

        protected void setGroupingAndGroupSize(DecimalFormat format) {
            if (format != null) {
                boolean useGrouping = format.isGroupingUsed();
                if (useGrouping) {
                    DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
                    this.actualGrouping = symbols.getGroupingSeparator();
                    this.actualGroupSize = format.getGroupingSize();
                    boolean bl = useGrouping = this.actualGroupSize > 0;
                }
                if (!useGrouping) {
                    this.actualGrouping = (char)65535;
                    this.actualGroupSize = -1;
                }
            }
        }

        protected void groupWholePartIfRequired() {
            if (Spec.specified(this.actualGrouping)) {
                this.groupDigits(this.actualGroupSize, this.actualGrouping);
            }
        }

        protected void groupDigits(int groupSize, char comma) {
            int commasNeeded = (this.lenWhole - 1) / groupSize;
            if (commasNeeded > 0) {
                int from = this.start + this.lenSign + this.lenWhole;
                this.makeSpaceAt(from, commasNeeded);
                int to = from + commasNeeded;
                this.lenWhole += commasNeeded;
                while (to > from) {
                    for (int i = 0; i < groupSize; ++i) {
                        this.result.setCharAt(--to, this.result.charAt(--from));
                    }
                    this.result.setCharAt(--to, comma);
                }
            }
        }

        protected void makeSpaceAt(int pos, int size) {
            int n = this.result.length();
            if (pos < n) {
                String tail = this.result.substring(pos);
                this.result.setLength(n + size);
                this.result.replace(pos + size, n + size, tail);
            } else {
                this.result.setLength(n + size);
            }
        }

        protected void uppercase() {
            int end = this.result.length();
            for (int i = this.start; i < end; ++i) {
                char c = this.result.charAt(i);
                this.result.setCharAt(i, Character.toUpperCase(c));
            }
        }

        public Formatter pad() {
            int n = this.spec.width - (this.result.length() - this.mark);
            if (n > 0) {
                this.pad(this.mark, n);
            }
            return this;
        }

        protected void pad(int leftIndexArg, int n) {
            int i;
            int leftIndex = leftIndexArg;
            char align = this.spec.getAlign('>');
            char fill = this.spec.getFill(' ');
            int leading = n;
            if (align == '^') {
                leading = n / 2;
            } else if (align == '<') {
                leading = 0;
            }
            int trailing = n - leading;
            if (leading > 0) {
                if (align == '=') {
                    leftIndex = this.start + this.lenSign;
                    this.lenWhole += leading;
                } else {
                    this.start += leading;
                }
                this.makeSpaceAt(leftIndex, leading);
                for (i = 0; i < leading; ++i) {
                    this.result.setCharAt(leftIndex + i, fill);
                }
            }
            for (i = 0; i < trailing; ++i) {
                this.result.append(fill);
            }
            if (align == '=' && fill == '0' && Spec.specified(this.actualGrouping)) {
                this.zeroPadAfterSignWithGroupingFixup(this.actualGroupSize, this.actualGrouping);
            }
        }

        protected void zeroPadAfterSignWithGroupingFixup(int groupSize, char comma) {
            int firstZero = this.start + this.lenSign;
            int p = firstZero + this.lenWhole;
            int step = groupSize + 1;
            p -= step;
            while (p >= firstZero) {
                this.result.setCharAt(p, comma);
                p -= step;
            }
            if (p + step == firstZero) {
                this.result.insert(firstZero, '0');
                ++this.lenWhole;
            }
        }

        public static PException unknownFormat(char code, String forType, Node raisingNode) {
            throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, ErrorMessages.UNKNOWN_FORMAT_CODE, Character.valueOf(code), forType);
        }

        public PException precisionTooLarge(String type) {
            throw PRaiseNode.raiseUncached(this.raisingNode, PythonErrorType.OverflowError, ErrorMessages.FORMATED_S_TOO_LONG, type);
        }
    }
}

