/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.Map;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.service.ServiceRegistry;

public abstract class AbstractCompositeIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    protected final Class compositeIdClass;
    protected Map<PropertyData, SingleIdMapper> ids;

    protected AbstractCompositeIdMapper(Class compositeIdClass, ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
        this.compositeIdClass = compositeIdClass;
        this.ids = Tools.newLinkedHashMap();
    }

    @Override
    public void add(PropertyData propertyData) {
        this.ids.put(propertyData, new SingleIdMapper(this.getServiceRegistry(), propertyData));
    }

    @Override
    public Object mapToIdFromMap(Map data) {
        Object ret;
        if (data == null) {
            return null;
        }
        try {
            ret = ReflectHelper.getDefaultConstructor((Class)this.compositeIdClass).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
        for (SingleIdMapper mapper : this.ids.values()) {
            if (mapper.mapToEntityFromMap(ret, data)) continue;
            return null;
        }
        return ret;
    }
}

