/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ccex.dto.trade.CCEXBuySellLimitResponse;
import org.knowm.xchange.ccex.dto.trade.CCEXCancelResponse;
import org.knowm.xchange.ccex.dto.trade.CCEXGetopenordersResponse;
import org.knowm.xchange.ccex.dto.trade.CCEXGetorderhistoryResponse;
import org.knowm.xchange.ccex.dto.trade.CCEXOpenorder;
import org.knowm.xchange.ccex.dto.trade.CCEXOrderhistory;
import org.knowm.xchange.ccex.service.CCEXBaseService;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class CCEXTradeServiceRaw
extends CCEXBaseService {
    public CCEXTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<CCEXOpenorder> getCCEXOpenOrders() throws IOException {
        CCEXGetopenordersResponse response = this.cCEXAuthenticated.getopenorders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.isSuccess()) {
            return response.getResult();
        }
        throw new ExchangeException(response.getMessage());
    }

    public List<CCEXOrderhistory> getCCEXTradeHistory() throws IOException {
        CCEXGetorderhistoryResponse response = this.cCEXAuthenticated.getorderhistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.isSuccess()) {
            return response.getResult();
        }
        throw new ExchangeException(response.getMessage());
    }

    public boolean cancelCCEXLimitOrder(String uuid) throws IOException {
        CCEXCancelResponse response = this.cCEXAuthenticated.cancel(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uuid);
        if (response.isSuccess()) {
            return true;
        }
        throw new ExchangeException(response.getMessage());
    }

    public String placeCCEXLimitOrder(LimitOrder limitOrder) throws IOException {
        String lpair = limitOrder.getCurrencyPair().base.toString().toLowerCase();
        String rpair = limitOrder.getCurrencyPair().counter.toString().toLowerCase();
        if (limitOrder.getType() == Order.OrderType.BID) {
            CCEXBuySellLimitResponse response = this.cCEXAuthenticated.buylimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), lpair, rpair, limitOrder.getTradableAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString());
            if (response.isSuccess()) {
                return response.getResult().getUuid();
            }
            throw new ExchangeException(response.getMessage());
        }
        CCEXBuySellLimitResponse response = this.cCEXAuthenticated.selllimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), lpair, rpair, limitOrder.getTradableAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString());
        if (response.isSuccess()) {
            return response.getResult().getUuid();
        }
        throw new ExchangeException(response.getMessage());
    }
}

