/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.internal.async.client.AsyncChangeStreamIterable;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ChangeStreamPublisherImpl<TResult>
implements ChangeStreamPublisher<TResult> {
    private final AsyncChangeStreamIterable<TResult> wrapped;

    ChangeStreamPublisherImpl(AsyncChangeStreamIterable<TResult> wrapped) {
        this.wrapped = (AsyncChangeStreamIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public ChangeStreamPublisher<TResult> fullDocument(FullDocument fullDocument) {
        this.wrapped.fullDocument(fullDocument);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> resumeAfter(BsonDocument resumeToken) {
        this.wrapped.resumeAfter(resumeToken);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.wrapped.startAtOperationTime(startAtOperationTime);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> startAfter(BsonDocument startAfter) {
        this.wrapped.startAfter(startAfter);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Override
    public <TDocument> Publisher<TDocument> withDocumentClass(Class<TDocument> clazz) {
        return Publishers.publish(this.wrapped.withDocumentClass(clazz));
    }

    @Override
    public ChangeStreamPublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<ChangeStreamDocument<TResult>> first() {
        return Publishers.publish(arg_0 -> this.wrapped.first(arg_0));
    }

    public void subscribe(Subscriber<? super ChangeStreamDocument<TResult>> s) {
        Publishers.publish(this.wrapped).subscribe(s);
    }
}

