/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.linuxstuff.mojo.licensing.AbstractLicensingMojo;
import org.linuxstuff.mojo.licensing.model.ArtifactWithLicenses;
import org.linuxstuff.mojo.licensing.model.LicensingReport;

public class CollectReportsMojo
extends AbstractLicensingMojo {
    private MavenProjectHelper projectHelper;
    private List<MavenProject> reactorProjects;
    private LicensingReport report;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.readLicensingRequirements();
        this.report = new LicensingReport();
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.processAnnotations(ArtifactWithLicenses.class);
        xstream.processAnnotations(LicensingReport.class);
        for (MavenProject p : this.reactorProjects) {
            File licenseXml = new File(p.getBuild().getDirectory(), this.thirdPartyLicensingFilename);
            if (licenseXml.canRead()) {
                LicensingReport artifactReport = (LicensingReport)xstream.fromXML(licenseXml);
                this.getLog().debug((CharSequence)("Successfully turned " + licenseXml + " into " + artifactReport));
                this.report.combineWith(artifactReport);
                continue;
            }
            this.getLog().debug((CharSequence)("No report file found at: " + licenseXml.getAbsolutePath()));
        }
        File outputFile = new File(this.project.getBuild().getDirectory(), this.aggregatedThirdPartyLicensingFilename);
        this.report.writeReport(outputFile);
        this.projectHelper.attachArtifact(this.project, outputFile, "aggregated-third-party-licensing");
    }
}

