/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.HashSet;
import java.util.Set;
import org.linuxstuff.mojo.licensing.model.ArtifactWithLicenses;
import org.linuxstuff.mojo.licensing.model.CoalescedLicense;
import org.linuxstuff.mojo.licensing.model.DualLicense;

@XStreamAlias(value="licensing-requirements")
public class LicensingRequirements {
    @XStreamAlias(value="missing-licenses")
    private Set<ArtifactWithLicenses> missingLicenses = new HashSet<ArtifactWithLicenses>();
    @XStreamAlias(value="override-licenses")
    private Set<ArtifactWithLicenses> overrideLicenses = new HashSet<ArtifactWithLicenses>();
    @XStreamAlias(value="missing-artifacts")
    private Set<ArtifactWithLicenses> missingArtifacts = new HashSet<ArtifactWithLicenses>();
    @XStreamAlias(value="coalesced-licenses")
    private Set<CoalescedLicense> coalescedLicenses = new HashSet<CoalescedLicense>();
    @XStreamAlias(value="dual-licenses")
    private Set<DualLicense> dualLicenses = new HashSet<DualLicense>();
    @XStreamAlias(value="disliked-licenses")
    @XStreamImplicit(itemFieldName="disliked-license")
    private Set<String> dislikedLicenses = new HashSet<String>();
    @XStreamAlias(value="liked-licenses")
    @XStreamImplicit(itemFieldName="liked-license")
    private Set<String> likedLicenses = new HashSet<String>();
    @XStreamAlias(value="dislike-exemptions")
    @XStreamImplicit(itemFieldName="dislike-exemption")
    private Set<String> dislikeExemptions = new HashSet<String>();

    public void addArtifactMissingLicense(ArtifactWithLicenses missingLicense) {
        this.missingLicenses.add(missingLicense);
    }

    public void addOverrideLicense(ArtifactWithLicenses overrideLicense) {
        this.overrideLicenses.add(overrideLicense);
    }

    public void addMissingArtifact(ArtifactWithLicenses missingArtifact) {
        this.missingArtifacts.add(missingArtifact);
    }

    public void addCoalescedLicense(CoalescedLicense coalescedLicense) {
        this.coalescedLicenses.add(coalescedLicense);
    }

    public void addDualLicense(DualLicense dualLicense) {
        this.dualLicenses.add(dualLicense);
    }

    public void addDislikedLicense(String licenseName) {
        this.dislikedLicenses.add(licenseName);
    }

    public void addLikedLicense(String licenseName) {
        this.likedLicenses.add(licenseName);
    }

    public void addDislikeExemption(String artifactId) {
        this.dislikeExemptions.add(artifactId);
    }

    public boolean isDislikedLicense(String license) {
        return this.dislikedLicenses.contains(license);
    }

    public boolean isLikedLicense(String license) {
        return this.likedLicenses.contains(license);
    }

    public String getCorrectLicenseName(String name) {
        for (CoalescedLicense coalesced : this.coalescedLicenses) {
            if (coalesced.getFinalName().equalsIgnoreCase(name.trim())) {
                return coalesced.getFinalName();
            }
            for (String otherName : coalesced.getOtherNames()) {
                if (!otherName.equalsIgnoreCase(name.trim())) continue;
                return coalesced.getFinalName();
            }
        }
        return name;
    }

    public void normalizeLicenses(ArtifactWithLicenses artifact) {
        String id = artifact.getArtifactId();
        for (ArtifactWithLicenses replacement : this.overrideLicenses) {
            if (!id.startsWith(replacement.getArtifactId())) continue;
            artifact.setLicenses(replacement.getLicenses());
            break;
        }
        HashSet<String> normalizedLicenses = new HashSet<String>();
        for (String license : artifact.getLicenses()) {
            String correct = this.getCorrectLicenseName(license);
            boolean found = false;
            for (DualLicense dualLicense : this.getDualLicenses()) {
                if (!correct.equals(dualLicense.getFinalName())) continue;
                for (String option : dualLicense.getOptionalLicenses()) {
                    normalizedLicenses.add(option);
                }
                found = true;
            }
            if (found) continue;
            normalizedLicenses.add(correct);
        }
        artifact.setLicenses(normalizedLicenses);
    }

    public boolean isExemptFromDislike(String artifactId) {
        if (this.dislikeExemptions == null) {
            return false;
        }
        return this.dislikeExemptions.contains(artifactId);
    }

    public Set<String> getLicenseNames(String id) {
        HashSet<String> licenses = new HashSet<String>();
        for (ArtifactWithLicenses missing : this.missingLicenses) {
            if (!missing.getArtifactId().equals(id)) continue;
            licenses.addAll(missing.getLicenses());
        }
        return licenses;
    }

    public boolean containsDislikedLicenses() {
        return !this.dislikedLicenses.isEmpty();
    }

    public boolean containsLikedLicenses() {
        return !this.likedLicenses.isEmpty();
    }

    public Set<ArtifactWithLicenses> getMissingLicenses() {
        return this.missingLicenses;
    }

    public Set<ArtifactWithLicenses> getOverrideLicenses() {
        return this.overrideLicenses;
    }

    public Set<ArtifactWithLicenses> getMissingArtifacts() {
        return this.missingArtifacts;
    }

    public Set<CoalescedLicense> getCoalescedLicenses() {
        return this.coalescedLicenses;
    }

    public Set<DualLicense> getDualLicenses() {
        return this.dualLicenses;
    }

    public Set<String> getDislikedLicenses() {
        return this.dislikedLicenses;
    }

    public Set<String> getLikedLicenses() {
        return this.likedLicenses;
    }

    public Set<String> getDislikeExemptions() {
        return this.dislikeExemptions;
    }

    public void combineWith(LicensingRequirements req) {
        if (req.getDislikedLicenses() != null) {
            for (String string : req.getDislikedLicenses()) {
                this.addDislikedLicense(string);
            }
        }
        if (req.getLikedLicenses() != null) {
            for (String string : req.getLikedLicenses()) {
                this.addLikedLicense(string);
            }
        }
        if (req.getDislikeExemptions() != null) {
            for (String string : req.getDislikeExemptions()) {
                this.addDislikeExemption(string);
            }
        }
        this.mergeArtifactsWithLicenses(req.getMissingLicenses(), this.getMissingLicenses());
        this.mergeArtifactsWithLicenses(req.getOverrideLicenses(), this.getOverrideLicenses());
        this.mergeArtifactsWithLicenses(req.getMissingArtifacts(), this.getMissingArtifacts());
        if (req.getCoalescedLicenses() != null) {
            for (CoalescedLicense coalescedLicense : req.getCoalescedLicenses()) {
                if (this.getCoalescedLicenses().contains(coalescedLicense)) {
                    for (CoalescedLicense coalescedLicense2 : this.getCoalescedLicenses()) {
                        if (!coalescedLicense.equals(coalescedLicense2)) continue;
                        coalescedLicense2.combineWith(coalescedLicense);
                    }
                    continue;
                }
                this.addCoalescedLicense(coalescedLicense);
            }
        }
        if (req.getDualLicenses() != null) {
            for (DualLicense dualLicense : req.getDualLicenses()) {
                if (this.getDualLicenses().contains(dualLicense)) {
                    for (DualLicense dualLicense2 : this.getDualLicenses()) {
                        if (!dualLicense.equals(dualLicense2)) continue;
                        dualLicense2.combineWith(dualLicense);
                    }
                    continue;
                }
                this.addDualLicense(dualLicense);
            }
        }
    }

    private void mergeArtifactsWithLicenses(Set<ArtifactWithLicenses> sourceArtifacts, Set<ArtifactWithLicenses> destinationArtifacts) {
        if (sourceArtifacts != null) {
            for (ArtifactWithLicenses source : sourceArtifacts) {
                if (destinationArtifacts.contains(source)) {
                    for (ArtifactWithLicenses destination : destinationArtifacts) {
                        if (!source.equals(destination)) continue;
                        destination.combineWith(source);
                    }
                    continue;
                }
                destinationArtifacts.add(source);
            }
        }
    }
}

