/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import java.util.concurrent.Flow;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowAdapters {
    private FlowAdapters() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Publisher<T> toPublisher(Flow.Publisher<? extends T> flowPublisher) {
        if (flowPublisher == null) {
            throw new NullPointerException("flowPublisher");
        }
        if (flowPublisher instanceof FlowPublisherFromReactive) {
            return ((FlowPublisherFromReactive)flowPublisher).reactiveStreams;
        }
        if (flowPublisher instanceof Publisher) {
            return (Publisher)flowPublisher;
        }
        return new ReactivePublisherFromFlow<T>(flowPublisher);
    }

    public static <T> Flow.Publisher<T> toFlowPublisher(Publisher<? extends T> reactiveStreamsPublisher) {
        if (reactiveStreamsPublisher == null) {
            throw new NullPointerException("reactiveStreamsPublisher");
        }
        if (reactiveStreamsPublisher instanceof ReactivePublisherFromFlow) {
            return ((ReactivePublisherFromFlow)reactiveStreamsPublisher).flow;
        }
        if (reactiveStreamsPublisher instanceof Flow.Publisher) {
            return (Flow.Publisher)reactiveStreamsPublisher;
        }
        return new FlowPublisherFromReactive<T>(reactiveStreamsPublisher);
    }

    public static <T, U> Processor<T, U> toProcessor(Flow.Processor<? super T, ? extends U> flowProcessor) {
        if (flowProcessor == null) {
            throw new NullPointerException("flowProcessor");
        }
        if (flowProcessor instanceof FlowToReactiveProcessor) {
            return ((FlowToReactiveProcessor)flowProcessor).reactiveStreams;
        }
        if (flowProcessor instanceof Processor) {
            return (Processor)flowProcessor;
        }
        return new ReactiveToFlowProcessor<T, U>(flowProcessor);
    }

    public static <T, U> Flow.Processor<T, U> toFlowProcessor(Processor<? super T, ? extends U> reactiveStreamsProcessor) {
        if (reactiveStreamsProcessor == null) {
            throw new NullPointerException("reactiveStreamsProcessor");
        }
        if (reactiveStreamsProcessor instanceof ReactiveToFlowProcessor) {
            return ((ReactiveToFlowProcessor)reactiveStreamsProcessor).flow;
        }
        if (reactiveStreamsProcessor instanceof Flow.Processor) {
            return (Flow.Processor)reactiveStreamsProcessor;
        }
        return new FlowToReactiveProcessor<T, U>(reactiveStreamsProcessor);
    }

    public static <T> Flow.Subscriber<T> toFlowSubscriber(Subscriber<T> reactiveStreamsSubscriber) {
        if (reactiveStreamsSubscriber == null) {
            throw new NullPointerException("reactiveStreamsSubscriber");
        }
        if (reactiveStreamsSubscriber instanceof ReactiveToFlowSubscriber) {
            return ((ReactiveToFlowSubscriber)reactiveStreamsSubscriber).flow;
        }
        if (reactiveStreamsSubscriber instanceof Flow.Subscriber) {
            return (Flow.Subscriber)reactiveStreamsSubscriber;
        }
        return new FlowToReactiveSubscriber<T>(reactiveStreamsSubscriber);
    }

    public static <T> Subscriber<T> toSubscriber(Flow.Subscriber<T> flowSubscriber) {
        if (flowSubscriber == null) {
            throw new NullPointerException("flowSubscriber");
        }
        if (flowSubscriber instanceof FlowToReactiveSubscriber) {
            return ((FlowToReactiveSubscriber)flowSubscriber).reactiveStreams;
        }
        if (flowSubscriber instanceof Subscriber) {
            return (Subscriber)flowSubscriber;
        }
        return new ReactiveToFlowSubscriber<T>(flowSubscriber);
    }

    static final class FlowPublisherFromReactive<T>
    implements Flow.Publisher<T> {
        final Publisher<? extends T> reactiveStreams;

        public FlowPublisherFromReactive(Publisher<? extends T> reactivePublisher) {
            this.reactiveStreams = reactivePublisher;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> flow) {
            this.reactiveStreams.subscribe((Subscriber)(flow == null ? null : new ReactiveToFlowSubscriber<T>(flow)));
        }
    }

    static final class ReactivePublisherFromFlow<T>
    implements Publisher<T> {
        final Flow.Publisher<? extends T> flow;

        public ReactivePublisherFromFlow(Flow.Publisher<? extends T> flowPublisher) {
            this.flow = flowPublisher;
        }

        public void subscribe(Subscriber<? super T> reactive) {
            this.flow.subscribe(reactive == null ? null : new FlowToReactiveSubscriber<T>(reactive));
        }
    }

    static final class FlowToReactiveProcessor<T, U>
    implements Flow.Processor<T, U> {
        final Processor<? super T, ? extends U> reactiveStreams;

        public FlowToReactiveProcessor(Processor<? super T, ? extends U> reactive) {
            this.reactiveStreams = reactive;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.reactiveStreams.onSubscribe((Subscription)(subscription == null ? null : new ReactiveToFlowSubscription(subscription)));
        }

        @Override
        public void onNext(T t) {
            this.reactiveStreams.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.reactiveStreams.onError(t);
        }

        @Override
        public void onComplete() {
            this.reactiveStreams.onComplete();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super U> s) {
            this.reactiveStreams.subscribe((Subscriber)(s == null ? null : new ReactiveToFlowSubscriber<U>(s)));
        }
    }

    static final class ReactiveToFlowProcessor<T, U>
    implements Processor<T, U> {
        final Flow.Processor<? super T, ? extends U> flow;

        public ReactiveToFlowProcessor(Flow.Processor<? super T, ? extends U> flow) {
            this.flow = flow;
        }

        public void onSubscribe(Subscription subscription) {
            this.flow.onSubscribe(subscription == null ? null : new FlowToReactiveSubscription(subscription));
        }

        public void onNext(T t) {
            this.flow.onNext(t);
        }

        public void onError(Throwable t) {
            this.flow.onError(t);
        }

        public void onComplete() {
            this.flow.onComplete();
        }

        public void subscribe(Subscriber<? super U> s) {
            this.flow.subscribe(s == null ? null : new FlowToReactiveSubscriber<U>(s));
        }
    }

    static final class ReactiveToFlowSubscriber<T>
    implements Subscriber<T> {
        final Flow.Subscriber<? super T> flow;

        public ReactiveToFlowSubscriber(Flow.Subscriber<? super T> flow) {
            this.flow = flow;
        }

        public void onSubscribe(Subscription subscription) {
            this.flow.onSubscribe(subscription == null ? null : new FlowToReactiveSubscription(subscription));
        }

        public void onNext(T item) {
            this.flow.onNext(item);
        }

        public void onError(Throwable throwable) {
            this.flow.onError(throwable);
        }

        public void onComplete() {
            this.flow.onComplete();
        }
    }

    static final class FlowToReactiveSubscriber<T>
    implements Flow.Subscriber<T> {
        final Subscriber<? super T> reactiveStreams;

        public FlowToReactiveSubscriber(Subscriber<? super T> reactive) {
            this.reactiveStreams = reactive;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.reactiveStreams.onSubscribe((Subscription)(subscription == null ? null : new ReactiveToFlowSubscription(subscription)));
        }

        @Override
        public void onNext(T item) {
            this.reactiveStreams.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.reactiveStreams.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.reactiveStreams.onComplete();
        }
    }

    static final class ReactiveToFlowSubscription
    implements Subscription {
        final Flow.Subscription flow;

        public ReactiveToFlowSubscription(Flow.Subscription flow) {
            this.flow = flow;
        }

        public void request(long n) {
            this.flow.request(n);
        }

        public void cancel() {
            this.flow.cancel();
        }
    }

    static final class FlowToReactiveSubscription
    implements Flow.Subscription {
        final Subscription reactiveStreams;

        public FlowToReactiveSubscription(Subscription reactive) {
            this.reactiveStreams = reactive;
        }

        @Override
        public void request(long n) {
            this.reactiveStreams.request(n);
        }

        @Override
        public void cancel() {
            this.reactiveStreams.cancel();
        }
    }
}

