/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe.util;

public enum Status {
    VALID(true, "The CPE value is valid"),
    UNQUOTED_QUESTION_MARK(false, "CPE Strings may not contain unquoted question marks except at the beginning or end of the string"),
    UNQUOTED_ASTERISK(false, "CPE strings may only contain unquoted asterisk at the beginning or end of the string"),
    ASTERISK_SEQUENCE(false, "CPE strings may not contain multiple asterisk characters in sequence"),
    NON_PRINTABLE(false, "CPE strings may only contain printable characters in the UTF-8 character set between x00 and x7F"),
    WHITESPACE(false, "CPE strings may not contain whitespace; consider using an underscore instead"),
    SINGLE_QUOTED_HYPHEN(false, "CPE components cannot be a single quoted hyphen"),
    EMPTY(false, "CPE components may not be empty or null"),
    TOO_MANY_ELEMENTS(false, "The CPE value has too many components"),
    TOO_FEW_ELEMENTS(false, "The CPE value has too few components"),
    INVALID_PART(false, "The CPE value has an invalid part defined"),
    INVALID(false, "The CPE value is invalid");

    private final boolean valid;
    private final String message;

    private Status(boolean valid, String message) {
        this.valid = valid;
        this.message = message;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMessage() {
        return this.message;
    }
}

