/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class JPEGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_QUALITY = new QualityKey();

    public JPEGTranscoder() {
        this.hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        float quality;
        OutputStream ostream = output.getOutputStream();
        if ((ostream = new OutputStreamWrapper(ostream)) == null) {
            throw new TranscoderException(Messages.formatMessage("jpeg.badoutput", null));
        }
        if (this.hints.containsKey(KEY_QUALITY)) {
            quality = ((Float)this.hints.get(KEY_QUALITY)).floatValue();
        } else {
            this.handler.error(new TranscoderException(Messages.formatMessage("jpeg.unspecifiedQuality", null)));
            quality = 1.0f;
        }
        try {
            JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)ostream);
            JPEGEncodeParam params = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)img);
            params.setQuality(quality, true);
            jpegEncoder.encode(img, params);
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }

    private static class OutputStreamWrapper
    extends OutputStream {
        OutputStream os;

        OutputStreamWrapper(OutputStream os) {
            this.os = os;
        }

        public void close() throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.close();
            }
            catch (IOException ioe) {
                this.os = null;
            }
        }

        public void flush() throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.flush();
            }
            catch (IOException ioe) {
                this.os = null;
            }
        }

        public void write(byte[] b) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(b);
            }
            catch (IOException ioe) {
                this.os = null;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(b, off, len);
            }
            catch (IOException ioe) {
                this.os = null;
            }
        }

        public void write(int b) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(b);
            }
            catch (IOException ioe) {
                this.os = null;
            }
        }
    }

    private static class QualityKey
    extends TranscodingHints.Key {
        private QualityKey() {
        }

        public boolean isCompatibleValue(Object v) {
            if (v instanceof Float) {
                float q = ((Float)v).floatValue();
                return q > 0.0f && q <= 1.0f;
            }
            return false;
        }
    }
}

