/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands;

import csbase.client.algorithms.commands.CommandPropertiesFilter;
import csbase.client.algorithms.commands.CommandViewerTable;
import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.client.remote.srvproxies.SchedulerProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class CommandViewerPanel
extends JPanel {
    private Action exportCommandAction;
    private DesktopComponentFrame frame;
    private AbstractAction removeCommandAction;
    private AbstractAction killCommandAction;
    private Action showCommandAction;
    private Action showCommandLogAction;
    private final CommandViewerTable table;

    protected CommandViewerPanel(DesktopComponentFrame frame, Object projectId) {
        this(frame, projectId, null, ToolBarLocation.TOP);
    }

    protected CommandViewerPanel(DesktopComponentFrame frame, Object projectId, CommandPropertiesFilter filter) {
        this(frame, projectId, filter, ToolBarLocation.TOP);
    }

    protected CommandViewerPanel(DesktopComponentFrame frame, Object projectId, CommandPropertiesFilter filter, ToolBarLocation toolBarLocation) {
        super(new BorderLayout());
        boolean isHorizontal;
        String location;
        this.setFrame(frame);
        this.createExportCommandAction();
        this.createRemoveCommandAction();
        this.createKillCommandAction();
        this.createShowCommandAction();
        this.createShowCommandLogAction();
        this.table = new CommandViewerTable(frame, projectId, filter);
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(this.createListSelectionListener());
        switch (toolBarLocation) {
            case TOP: {
                location = "North";
                isHorizontal = true;
                break;
            }
            case BOTTOM: {
                location = "South";
                isHorizontal = true;
                break;
            }
            case LEFT: {
                location = "West";
                isHorizontal = false;
                break;
            }
            case RIGHT: {
                location = "East";
                isHorizontal = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Posi\u00e7\u00e3o da barra de ferramentas inv\u00e1lida.\n" + (Object)((Object)toolBarLocation));
            }
        }
        this.add((Component)this.createToolBar(isHorizontal), location);
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
    }

    protected CommandViewerPanel(DesktopComponentFrame frame, String projectId, ToolBarLocation toolBarLocation) {
        this(frame, projectId, null, toolBarLocation);
    }

    public final Action getExportCommandAction() {
        return this.exportCommandAction;
    }

    public final Action getRemoveCommandAction() {
        return this.removeCommandAction;
    }

    public final Action getKillCommandAction() {
        return this.killCommandAction;
    }

    public final Action getShowCommandAction() {
        return this.showCommandAction;
    }

    public final Action getShowCommandLogAction() {
        return this.showCommandLogAction;
    }

    public final void start() {
        this.table.start();
    }

    public final void stop() {
        this.table.stop();
    }

    protected abstract boolean exportCommand(CommandInfo var1);

    private void createExportCommandAction() {
        this.exportCommandAction = new AbstractAction(this.getMessage("label_export_action"), ApplicationImages.ICON_EXECUTE_CMD_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandViewerPanel.this.exportSelectedCommand();
            }
        };
        this.exportCommandAction.putValue("ShortDescription", this.getMessage("tooltip_export_action"));
        this.exportCommandAction.setEnabled(false);
    }

    private ListSelectionListener createListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean enableSingleRowAction = 1 == CommandViewerPanel.this.table.getSelectedRows().length;
                CommandViewerPanel.this.exportCommandAction.setEnabled(enableSingleRowAction);
                CommandViewerPanel.this.showCommandAction.setEnabled(enableSingleRowAction);
                CommandViewerPanel.this.showCommandLogAction.setEnabled(enableSingleRowAction);
                List<CommandInfo> commands = CommandViewerPanel.this.table.getSelectedCommands();
                boolean enableRemove = 0 < CommandViewerPanel.this.table.getSelectedRows().length;
                for (CommandInfo command : commands) {
                    enableRemove &= command.getStatus() == CommandStatus.FINISHED | command.getStatus() == CommandStatus.SYSTEM_FAILURE;
                    enableRemove &= this.userHasAdminRightsToCommand(command);
                }
                CommandViewerPanel.this.removeCommandAction.setEnabled(enableRemove);
                boolean enableKill = 0 < CommandViewerPanel.this.table.getSelectedRows().length;
                for (CommandInfo command : commands) {
                    enableKill &= command.getStatus() == CommandStatus.SCHEDULED | command.getStatus() == CommandStatus.UPLOADING | command.getStatus() == CommandStatus.INIT | command.getStatus() == CommandStatus.EXECUTING | command.getStatus() == CommandStatus.DOWNLOADING;
                    enableKill &= this.userHasAdminRightsToCommand(command);
                }
                CommandViewerPanel.this.killCommandAction.setEnabled(enableKill);
            }

            private boolean userHasAdminRightsToCommand(CommandInfo command) {
                User loggedUser = User.getLoggedUser();
                CommonClientProject project = DesktopFrame.getInstance().getProject();
                return CommandViewerPanel.this.userOwnsCommand(command) || loggedUser.isAdmin() || CommandViewerPanel.this.userOwnsProject(project);
            }
        };
    }

    private void createRemoveCommandAction() {
        this.removeCommandAction = new AbstractAction(this.getMessage("label_remove_action"), ApplicationImages.ICON_DELETE_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandViewerPanel.this.removeSelectedCommands();
            }
        };
        this.removeCommandAction.setEnabled(false);
        this.removeCommandAction.putValue("ShortDescription", this.getMessage("tooltip_remove_action"));
    }

    private void createKillCommandAction() {
        this.killCommandAction = new AbstractAction(this.getMessage("label_kill_action"), ApplicationImages.ICON_STOP_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandViewerPanel.this.killSelectedCommands();
            }
        };
        this.killCommandAction.setEnabled(false);
        this.killCommandAction.putValue("ShortDescription", this.getMessage("tooltip_kill_action"));
    }

    private void createShowCommandAction() {
        this.showCommandAction = new AbstractAction(this.getMessage("label_show_action"), ApplicationImages.ICON_INFORMATION_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandViewerPanel.this.showSelectedCommand(TabType.PARAMETERS);
            }
        };
        this.showCommandAction.setEnabled(false);
        this.showCommandAction.putValue("ShortDescription", this.getMessage("tooltip_show_action"));
    }

    private void createShowCommandLogAction() {
        this.showCommandLogAction = new AbstractAction(this.getMessage("label_show_log_action"), ApplicationImages.ICON_VIEWLOG_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandViewerPanel.this.showSelectedCommand(TabType.LOG);
            }
        };
        this.showCommandLogAction.setEnabled(false);
        this.showCommandLogAction.putValue("ShortDescription", this.getMessage("tooltip_show_log_action"));
    }

    private JToolBar createToolBar(boolean isHorizontal) {
        JToolBar toolBar = new JToolBar();
        int orientation = isHorizontal ? 0 : 1;
        toolBar.setOrientation(orientation);
        toolBar.add(this.showCommandAction);
        toolBar.add(this.showCommandLogAction);
        toolBar.add(this.exportCommandAction);
        toolBar.add(this.killCommandAction);
        toolBar.add(this.removeCommandAction);
        return toolBar;
    }

    private boolean exportSelectedCommand() {
        List<CommandInfo> commands = this.table.getSelectedCommands();
        if (1 == commands.size()) {
            return this.exportCommand(commands.get(0));
        }
        return false;
    }

    private String getMessage(String keySuffix) {
        return LNG.get((String)(CommandViewerPanel.class.getSimpleName() + "." + keySuffix));
    }

    private boolean removeSelectedCommands() {
        if (!this.warnRemoveCommand()) {
            return false;
        }
        final List<CommandInfo> commands = this.table.getSelectedCommands();
        if (0 == commands.size()) {
            return true;
        }
        String taskTitle = this.getMessage("msg_removing_commands_title");
        StringBuilder sb = new StringBuilder();
        for (CommandInfo command : commands) {
            sb.append('\t').append(command.getId()).append('\n');
        }
        class RemoveCommandTask
        extends RemoteTask<boolean[]> {
            RemoveCommandTask() {
            }

            protected void performTask() throws RemoteException {
                this.setResult(CommandsCache.getInstance().removeCommands(commands));
            }
        }
        RemoveCommandTask task = new RemoveCommandTask();
        String taskMessage = String.format(this.getMessage("msg_removing_commands_content"), sb.toString());
        if (!task.execute(this.frame, taskTitle, taskMessage)) {
            return false;
        }
        boolean[] cmdsResult = (boolean[])task.getResult();
        boolean error = false;
        for (boolean cmdResult : cmdsResult) {
            error |= !cmdResult;
        }
        if (error) {
            StringBuilder errorCmds = new StringBuilder();
            for (int inx = 0; inx < commands.size(); ++inx) {
                if (cmdsResult[inx]) continue;
                errorCmds.append('\t').append(commands.get(inx).getId()).append('\n');
            }
            String errorMessage = String.format(this.getMessage("error_removing_commands"), errorCmds);
            this.showError(errorMessage);
        }
        return !error;
    }

    private boolean killSelectedCommands() {
        if (!this.warnKillCommand()) {
            return false;
        }
        boolean success = true;
        List<CommandInfo> commands = this.table.getSelectedCommands();
        boolean[] cmdsRemoveds = new boolean[commands.size()];
        for (int inx = 0; inx < commands.size(); ++inx) {
            CommandInfo cmd = commands.get(inx);
            String cmdId = cmd.getId();
            if (CommandStatus.SCHEDULED.equals((Object)cmd.getStatus())) {
                cmdsRemoveds[inx] = SchedulerProxy.removeCommand(this.frame, cmdId);
            } else {
                String sgaName = cmd.getSGAName();
                cmdsRemoveds[inx] = SGAProxy.killCommand(sgaName, cmdId);
            }
            success &= cmdsRemoveds[inx];
        }
        if (!success) {
            StringBuilder errorCmds = new StringBuilder();
            for (int inx = 0; inx < commands.size(); ++inx) {
                if (cmdsRemoveds[inx]) continue;
                errorCmds.append('\t').append(commands.get(inx).getId());
                String description = commands.get(inx).getDescription();
                if (description != null && description.trim().length() > 0) {
                    errorCmds.append("(").append(description).append(")");
                }
                errorCmds.append('\n');
            }
            String errorMessage = String.format(this.getMessage("error_killing_commands"), errorCmds);
            this.showError(errorMessage);
        }
        return success;
    }

    private void setFrame(DesktopComponentFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("frame == null");
        }
        this.frame = frame;
    }

    private void showError(String errorMessage) {
        StandardErrorDialogs.showErrorDialog((Window)this.frame, errorMessage);
    }

    private int showOptionDialog(String msg) {
        String title = this.frame.getTitle();
        return StandardDialogs.showYesNoDialog((Component)this.frame, (String)title, (Object)msg);
    }

    private boolean showSelectedCommand(TabType preferredTab) {
        return this.table.showSelectedCommand(preferredTab);
    }

    protected boolean userOwnsSelectedCommands() {
        for (CommandInfo command : this.table.getSelectedCommands()) {
            if (this.userOwnsCommand(command)) continue;
            return false;
        }
        return true;
    }

    protected boolean userOwnsCommand(CommandInfo command) {
        User loggedUser = User.getLoggedUser();
        return loggedUser.getId().equals(command.getUserId());
    }

    private boolean userOwnsProject(CommonClientProject project) {
        User loggedUser = User.getLoggedUser();
        return loggedUser.getId().equals(project.getUserId());
    }

    private boolean warnRemoveCommand() {
        String message = this.userOwnsSelectedCommands() ? this.getMessage("msg_warn_command_remove") : this.getMessage("msg_warn_command_remove_not_owner");
        int option = this.showOptionDialog(message);
        switch (option) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        String errorMessage = String.format("Op\u00e7\u00e3o inv\u00e1lida.\nOp\u00e7\u00e3o: %d.\n", option);
        throw new IllegalStateException(errorMessage);
    }

    private boolean warnKillCommand() {
        String message = this.userOwnsSelectedCommands() ? this.getMessage("msg_warn_command_kill") : this.getMessage("msg_warn_command_kill_not_owner");
        int option = this.showOptionDialog(message);
        switch (option) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        String errorMessage = String.format("Op\u00e7\u00e3o inv\u00e1lida.\nOp\u00e7\u00e3o: %d.\n", option);
        throw new IllegalStateException(errorMessage);
    }

    public List<CommandInfo> getSelectedCommands() {
        return this.table.getSelectedCommands();
    }

    public static enum ToolBarLocation {
        TOP,
        RIGHT,
        LEFT,
        BOTTOM;

    }
}

