/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.EnumerationParameterListener;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tecgraf.javautils.gui.GBC;

public final class EnumerationParameterView
extends SimpleParameterView<EnumerationItem> {
    @Deprecated
    public EnumerationParameterView(Window window, EnumerationParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    public EnumerationParameterView(EnumerationParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.getParameter().addEnumerationParameterListener(new EnumerationParameterListener(){

            public void enumerationItemWasSetVisible(EnumerationParameter param, EnumerationItem item) {
                EnumerationParameterView.this.updateViewContents();
            }
        });
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public EnumerationParameter getParameter() {
        return (EnumerationParameter)super.getParameter();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new EnumerationConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new EnumerationReportParameter();
    }

    @Override
    protected void updateViewContents() {
        ((IEnumerationParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    @Override
    public boolean fillVerticalSpace() {
        return false;
    }

    private final class EnumerationConfigurationParameter
    extends JPanel
    implements IEnumerationParameterComponent {
        private JComboBox comboBox;
        private MyComboBoxModel comboBoxModel;

        EnumerationConfigurationParameter() {
            this.setLayout(new GridLayout());
            this.comboBoxModel = new MyComboBoxModel();
            this.comboBox = new JComboBox(this.comboBoxModel);
            this.comboBox.setToolTipText(EnumerationParameterView.this.getParameter().getDescription());
            this.add((Component)this.comboBox, new GBC(0, 0).both());
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnumerationConfigurationParameter.this.updateModel();
                }
            });
            this.comboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    EnumerationItem item = (EnumerationItem)value;
                    if (item == null) {
                        this.setToolTipText(null);
                        this.setText("");
                    } else {
                        this.setText(item.getLabel());
                        if (item.getDescription() != null) {
                            this.setToolTipText(item.getDescription());
                        } else {
                            this.setToolTipText(EnumerationParameterView.this.getParameter().getDescription());
                        }
                    }
                    return this;
                }
            });
            this.updateViewContents();
        }

        @Override
        public void updateViewContents() {
            this.comboBoxModel.updateFromParameter();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.comboBox.setEnabled(isEnabled);
        }

        private void updateModel() {
            EnumerationItem selectedItem = (EnumerationItem)this.comboBox.getSelectedItem();
            EnumerationParameterView.this.getParameter().setValue((Object)selectedItem);
        }

        private final class MyComboBoxModel
        implements ComboBoxModel {
            private List<EnumerationItem> items;
            private List<ListDataListener> listeners = new LinkedList<ListDataListener>();
            private EnumerationItem selectedItem;

            MyComboBoxModel() {
                this.items = new LinkedList<EnumerationItem>();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListDataListener(ListDataListener l) {
                List<ListDataListener> list = this.listeners;
                synchronized (list) {
                    this.listeners.add(l);
                }
            }

            @Override
            public Object getElementAt(int index) {
                return this.items.get(index);
            }

            @Override
            public Object getSelectedItem() {
                return this.selectedItem;
            }

            @Override
            public int getSize() {
                return this.items.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListDataListener(ListDataListener l) {
                List<ListDataListener> list = this.listeners;
                synchronized (list) {
                    this.listeners.remove(l);
                }
            }

            @Override
            public void setSelectedItem(Object anItem) {
                this.selectedItem = (EnumerationItem)anItem;
                this.fireContentsChanged();
            }

            void updateFromParameter() {
                this.items.clear();
                for (EnumerationItem item : EnumerationParameterView.this.getParameter().getItems()) {
                    if (!item.isVisible()) continue;
                    this.items.add(item);
                }
                this.selectedItem = (EnumerationItem)EnumerationParameterView.this.getParameter().getValue();
                this.fireContentsChanged();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fireContentsChanged() {
                ListDataListener[] listenersArray;
                List<ListDataListener> list = this.listeners;
                synchronized (list) {
                    listenersArray = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
                }
                for (ListDataListener listener : listenersArray) {
                    ListDataEvent event = new ListDataEvent(EnumerationConfigurationParameter.this, 0, -1, -1);
                    listener.contentsChanged(event);
                }
            }
        }
    }

    private final class EnumerationReportParameter
    extends JTextField
    implements IEnumerationParameterComponent {
        EnumerationReportParameter() {
            this.setToolTipText(EnumerationParameterView.this.getParameter().getDescription());
            ComponentProperties.setProperties(this, ParameterView.Mode.REPORT, true);
            super.setEditable(false);
            this.updateViewContents();
        }

        @Override
        public void updateViewContents() {
            EnumerationItem selectedItem = (EnumerationItem)EnumerationParameterView.this.getParameter().getValue();
            if (selectedItem == null) {
                this.setToolTipText(null);
                this.setText(" ");
            } else {
                this.setText(selectedItem.getLabel());
                if (selectedItem.getDescription() != null) {
                    this.setToolTipText(selectedItem.getDescription());
                } else {
                    this.setToolTipText(EnumerationParameterView.this.getParameter().getDescription());
                }
            }
        }

        @Override
        public void setEditable(boolean enable) {
        }
    }

    private static interface IEnumerationParameterComponent {
        public void updateViewContents();
    }
}

