/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationUpdatedException;
import csbase.client.applicationmanager.CSDKCacheLocation;
import csbase.client.desktop.DesktopPref;
import csbase.client.desktop.RemoteTask;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVBoolean;
import csbase.client.preferences.types.PVString;
import csbase.logic.FileInfo;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.User;
import csbase.logic.Version;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ApplicationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationCache {
    public static boolean isApplicationVersionInCache(ApplicationRegistry registry) {
        FileInfo[] libInfos;
        File cacheDir = ApplicationCache.getCachePathForApplicationVersion(registry);
        if (!cacheDir.exists()) {
            return false;
        }
        for (FileInfo libInfo : libInfos = registry.getApplicationLibs()) {
            String fileName = libInfo.getName();
            File localFile = new File(cacheDir, fileName);
            if (localFile.exists()) continue;
            return false;
        }
        return true;
    }

    public static void clearCacheForApplication(ApplicationRegistry registry) throws ApplicationException {
        File cacheDir = ApplicationCache.getCacheBasePathForApplication(registry);
        if (cacheDir.exists()) {
            try {
                if (!FileUtils.delete((File)cacheDir)) {
                    String errorMsg = LNG.get((String)"application.manager.error.clear.app.cache");
                    throw new ApplicationException(errorMsg);
                }
            }
            catch (Exception e) {
                String errorMsg = LNG.get((String)"application.manager.error.clear.app.cache", (Object[])new Object[]{registry.getId()});
                throw new ApplicationException(errorMsg);
            }
        }
    }

    public static void clearCache() throws ApplicationException {
        File cacheDir = ApplicationCache.getCacheBasePath();
        if (cacheDir.exists()) {
            try {
                if (!FileUtils.delete((File)cacheDir)) {
                    String errorMsg = LNG.get((String)"application.manager.error.clear.cache");
                    throw new ApplicationException(errorMsg);
                }
            }
            catch (Exception e) {
                String errorMsg = LNG.get((String)"application.manager.error.clear.cache");
                throw new ApplicationException(errorMsg);
            }
        }
    }

    public static File getApplicationCache(ApplicationRegistry registry) throws ApplicationUpdatedException, ApplicationException {
        FileInfo[] libs = registry.getApplicationLibs();
        if (libs == null) {
            return null;
        }
        File cacheDir = ApplicationCache.getCachePathForApplicationVersion(registry);
        if (!ApplicationCache.isCacheEnabled() || !ApplicationCache.isApplicationVersionInCache(registry)) {
            boolean updated = ApplicationCache.wasApplicationUpdated(registry);
            if (updated) {
                throw new ApplicationUpdatedException("Application updated in server");
            }
            ApplicationCache.fillApplicationCache(registry, cacheDir, libs);
        }
        return cacheDir;
    }

    private static boolean isCacheEnabled() {
        PreferenceManager manager = PreferenceManager.getInstance();
        PreferenceCategory allPrefs = manager.loadPreferences();
        PreferenceCategory category = allPrefs.getCategory(DesktopPref.class);
        PVBoolean enabledProperty = category.getPVBoolean(DesktopPref.CSDK_CACHE_ENABLED);
        Boolean cacheEnabled = (Boolean)enabledProperty.getValue();
        return cacheEnabled;
    }

    private static File getCachePathForApplicationVersion(ApplicationRegistry registry) {
        File applicationDir = ApplicationCache.getCacheBasePathForApplication(registry);
        return new File(applicationDir, String.valueOf(registry.getTimestamp()));
    }

    private static File getCacheBasePathForApplication(ApplicationRegistry registry) {
        File baseDir = ApplicationCache.getCacheBasePath();
        return new File(baseDir, registry.getId());
    }

    private static File getCacheBasePath() {
        CSDKCacheLocation cacheLocation;
        PreferenceManager manager = PreferenceManager.getInstance();
        PreferenceCategory allPrefs = manager.loadPreferences();
        PreferenceCategory category = allPrefs.getCategory(DesktopPref.class);
        PVString cacheLocationPref = category.getPVString(DesktopPref.CSDK_CACHE_LOCATION);
        String cacheLocationValue = (String)cacheLocationPref.getValue();
        try {
            cacheLocation = CSDKCacheLocation.valueOf(cacheLocationValue);
        }
        catch (Exception e) {
            String defaultValue = (String)cacheLocationPref.getDefaultValue();
            try {
                cacheLocation = CSDKCacheLocation.valueOf(defaultValue);
            }
            catch (Exception e1) {
                cacheLocation = CSDKCacheLocation.JAVA_IO_TMPDIR;
            }
        }
        File baseDir = cacheLocation.getPath();
        if (baseDir == null || !baseDir.exists()) {
            baseDir = CSDKCacheLocation.JAVA_IO_TMPDIR.getPath();
        }
        Client client = Client.getInstance();
        String systemName = client.getSystemName();
        String systemDirName = "." + FileUtils.fixDirectoryName((String)systemName);
        File systemDir = new File(baseDir, systemDirName);
        Version v = Version.getInstance();
        String version = v.getVersion();
        String versionDirName = FileUtils.fixDirectoryName((String)version);
        File versionDir = new File(systemDir, versionDirName);
        User user = User.getLoggedUser();
        String login = user.getLogin();
        String userDirName = FileUtils.fixDirectoryName((String)login);
        File userDir = new File(versionDir, userDirName);
        return userDir;
    }

    private static void fillApplicationCache(ApplicationRegistry registry, final File cacheDir, final FileInfo[] libInfos) throws ApplicationException {
        String message;
        final ApplicationServiceInterface applicationService = ClientRemoteLocator.applicationService;
        if (applicationService == null) {
            return;
        }
        try {
            ApplicationCache.clearCacheForApplication(registry);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            String errorMsg = LNG.get((String)"application.manager.error.lib.dir", (Object[])new Object[]{cacheDir.getPath()});
            throw new ApplicationException(errorMsg);
        }
        final String appId = registry.getId();
        RemoteTask<Void> loadLibTask = new RemoteTask<Void>(){

            protected void performTask() throws RemoteException {
                for (FileInfo libInfo : libInfos) {
                    String[] resoursePath = libInfo.getPathAsArray();
                    RemoteFileChannelInfo fileChannel = applicationService.getApplicationResource(appId, resoursePath);
                    if (fileChannel == null) {
                        throw new RemoteException("Application resource not found in server: " + libInfo.getPath());
                    }
                    try {
                        String fileName = libInfo.getName();
                        File localFile = new File(cacheDir, fileName);
                        this.downloadFile(fileChannel, localFile);
                    }
                    catch (Exception e) {
                        throw new RemoteException("Error downloading application resource " + libInfo.getPath(), e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void downloadFile(RemoteFileChannelInfo info, File targetFile) throws IOException, PermissionException, FailureException, MaxClientsReachedException {
                FileOutputStream target = null;
                SyncRemoteFileChannel channel = null;
                try {
                    channel = new SyncRemoteFileChannel(info);
                    channel.open(true);
                    long size = channel.getSize();
                    target = new FileOutputStream(targetFile);
                    channel.syncTransferTo(0L, size, (OutputStream)target);
                    target.flush();
                }
                catch (Throwable throwable) {
                    FileUtils.close(target);
                    if (channel != null) {
                        channel.close();
                    }
                    throw throwable;
                }
                FileUtils.close((Closeable)target);
                if (channel != null) {
                    channel.close();
                }
            }
        };
        if (!loadLibTask.execute(null, null, message = LNG.get((String)"application.manager.task.lib.download", (Object[])new Object[]{appId}))) {
            String errorMsg = LNG.get((String)"application.manager.error.lib.download", (Object[])new Object[]{appId});
            throw new ApplicationException(errorMsg, loadLibTask.getError());
        }
    }

    private static boolean wasApplicationUpdated(ApplicationRegistry registry) {
        ApplicationServiceInterface appService = ClientRemoteLocator.applicationService;
        if (appService == null) {
            return false;
        }
        ApplicationRegistry serverRegistry = appService.getApplicationRegistry(registry.getId());
        if (serverRegistry == null) {
            return true;
        }
        Long serverTimestamp = serverRegistry.getTimestamp();
        if (serverTimestamp != null) {
            long localTimestamp = registry.getTimestamp();
            return serverTimestamp != localTimestamp;
        }
        return false;
    }
}

