/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationCache;
import csbase.client.applicationmanager.ApplicationCacheCorrupted;
import csbase.client.applicationmanager.ApplicationClassLoader;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationLink;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.applicationmanager.ApplicationStartAction;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applicationmanager.ApplicationUpdatedException;
import csbase.client.applicationmanager.InternalStructure;
import csbase.client.csdk.v1_0.application.CSDKApplication;
import csbase.client.desktop.DesktopPref;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVList;
import csbase.client.remote.srvproxies.EventLogProxy;
import csbase.logic.FileInfo;
import csbase.logic.RemoteFileInputStream;
import csbase.logic.applicationservice.AppPropertyResourceBundle;
import csbase.logic.applicationservice.ApplicationCategory;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ApplicationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import csdk.v1_0.api.application.IApplication;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public final class ApplicationManager {
    private final String appQueueName = "Applications";
    private final String[] appQueue = new String[]{"Applications"};
    private static ApplicationManager instance = null;
    private final Hashtable<String, ApplicationRegistry> registries;
    private final Hashtable<String, Vector<ApplicationType>> runningApplications = new Hashtable();
    private Locale locale = null;
    private Hashtable<String, Vector<String>> fileTypeAssociations = null;
    private final ArrayList<ApplicationManagerListener> listeners = new ArrayList();
    private final Hashtable<String, InternalStructure> structures = new Hashtable();
    private final Hashtable<String, ApplicationCategory> categories;

    public static ApplicationManager getInstance() {
        return instance;
    }

    public static void setInstance(Locale locale) throws RemoteException {
        if (instance == null) {
            instance = new ApplicationManager(locale);
        }
    }

    public final void addListener(ApplicationManagerListener listener) {
        this.listeners.add(listener);
    }

    private InternalStructure getInternalStructure(String id) {
        return this.structures.get(id);
    }

    private void buildFileTypesAssociations() {
        if (this.registries == null) {
            return;
        }
        this.fileTypeAssociations = new Hashtable();
        Enumeration<ApplicationRegistry> e = this.registries.elements();
        while (e.hasMoreElements()) {
            ApplicationRegistry reg = e.nextElement();
            List types = reg.getFileTypes();
            if (types == null) continue;
            for (String type : types) {
                Vector<String> apps = this.fileTypeAssociations.get(type);
                if (apps == null) {
                    Vector<String> newApps = new Vector<String>();
                    newApps.add(reg.getId());
                    this.fileTypeAssociations.put(type, newApps);
                    continue;
                }
                apps.add(reg.getId());
            }
        }
    }

    private boolean canEnableApplication(boolean hasProject, ApplicationRegistry reg) {
        if (!reg.isEnabled()) {
            return false;
        }
        if (!reg.isRunnable()) {
            return false;
        }
        if (reg.requireProject()) {
            return hasProject;
        }
        return true;
    }

    public AbstractAction createApplicationAction(String aid) {
        ApplicationRegistry reg = this.getApplicationRegistry(aid);
        if (reg == null) {
            return null;
        }
        InternalStructure structure = this.getInternalStructure(aid);
        AbstractAction action = structure.getAction();
        return action;
    }

    public JMenuItem createApplicationMenuItem(String aid, String text) {
        ApplicationRegistry reg = this.getApplicationRegistry(aid);
        if (reg == null) {
            return null;
        }
        AbstractAction action = this.createApplicationAction(aid);
        JMenuItem mi = new JMenuItem(action);
        if (text != null) {
            mi.setText(text);
        }
        return mi;
    }

    public ApplicationType createApplicationType(String id) throws ApplicationException {
        try {
            Vector<ApplicationType> running;
            ApplicationRegistry reg = this.getApplicationRegistry(id);
            if (reg == null) {
                String message = MessageFormat.format(LNG.get((String)"application.manager.no.registry"), id);
                throw new ApplicationException(message);
            }
            if (reg.isSingleton() && (running = this.runningApplications.get(id)) != null && running.size() > 0) {
                return running.get(0);
            }
            ClassLoader applicationClassLoader = this.createApplicationClassLoader(id);
            String className = reg.getClassName();
            Class<?> cls = Class.forName(className, true, applicationClassLoader);
            if (this.loadBundles(reg, cls)) {
                if (ApplicationType.class.isAssignableFrom(cls)) {
                    return this.createApplicationType(id, cls);
                }
                if (IApplication.class.isAssignableFrom(cls)) {
                    return this.createCSDK1_0Application(id, cls);
                }
                Object[] args = new Object[]{reg.getApplicationName(this.locale)};
                String msg = LNG.get((String)"application.manager.invalid.class", (Object[])args);
                throw new ApplicationException(msg);
            }
            Object[] args = new Object[]{reg.getApplicationName(this.locale), id, className};
            String msg = LNG.get((String)"application.manager.bundle.errors", (Object[])args);
            throw new ApplicationException(msg);
        }
        catch (OutOfMemoryError e) {
            String message = MessageFormat.format(LNG.get((String)"application.manager.out.of.memory"), id);
            throw new ApplicationException(message, e);
        }
        catch (ClassNotFoundException e) {
            String message = MessageFormat.format(LNG.get((String)"application.manager.no.class"), id);
            throw new ApplicationException(message, e);
        }
    }

    private ClassLoader createApplicationClassLoader(String id) throws ApplicationUpdatedException, ApplicationCacheCorrupted, ApplicationException {
        ApplicationRegistry reg = this.getApplicationRegistry(id);
        FileInfo[] libs = reg.getApplicationLibs();
        ClassLoader defaultClassLoader = this.getClass().getClassLoader();
        if (libs != null && libs.length > 0) {
            File libsDir = ApplicationCache.getApplicationCache(reg);
            if (libsDir == null) {
                throw new ApplicationCacheCorrupted();
            }
            URL[] libURLs = this.loadApplicationLibs(libsDir, libs);
            return new ApplicationClassLoader(libURLs, defaultClassLoader, reg.getClassLoaderWhiteList(), reg.getClassLoaderBlackList());
        }
        return defaultClassLoader;
    }

    public URL[] loadApplicationLibs(File libDir, FileInfo[] infos) throws ApplicationException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (FileInfo info : infos) {
            File libFile = new File(libDir, info.getName());
            if (!libFile.exists()) {
                throw new ApplicationCacheCorrupted("Application library not found: " + libFile.getPath());
            }
            try {
                URL url = libFile.toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                throw new ApplicationException(e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private boolean loadBundles(final ApplicationRegistry registry, final Class<?> mainClass) {
        AppPropertyResourceBundle resourceBundle = registry.getResourceBundle();
        if (resourceBundle != null) {
            return true;
        }
        final String urlPrefix = Client.getCodeBaseStr();
        RemoteTask<Boolean> loadBundleTask = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException {
                boolean bundleOk = true;
                if (registry.isBundleRequired()) {
                    bundleOk = false;
                    if (LNG.getNativeLocale() != null && !ApplicationManager.this.locale.equals(LNG.getNativeLocale())) {
                        bundleOk |= registry.loadClientBundles(mainClass, LNG.getNativeLocale());
                    }
                    bundleOk |= registry.loadClientBundles(mainClass, ApplicationManager.this.locale);
                    if (LNG.getNativeLocale() != null && !ApplicationManager.this.locale.equals(LNG.getNativeLocale())) {
                        bundleOk |= registry.loadServerBundles(ClientRemoteLocator.applicationService, LNG.getNativeLocale());
                    }
                    bundleOk |= registry.loadServerBundles(ClientRemoteLocator.applicationService, ApplicationManager.this.locale);
                }
                if (LNG.getNativeLocale() != null && !ApplicationManager.this.locale.equals(LNG.getNativeLocale())) {
                    registry.loadURLBundles(urlPrefix, LNG.getNativeLocale());
                }
                registry.loadURLBundles(urlPrefix, ApplicationManager.this.locale);
                this.setResult(bundleOk);
            }
        };
        if (loadBundleTask.execute(null, null, LNG.get((String)"application.manager.task.bundle"))) {
            return (Boolean)loadBundleTask.getResult();
        }
        return false;
    }

    private ApplicationType createApplicationType(String id, Class<? extends ApplicationType> appClass) throws ApplicationException {
        try {
            Class[] argClasses = new Class[]{String.class};
            Constructor<? extends ApplicationType> constructor = appClass.getConstructor(argClasses);
            Object[] pObjs = new Object[]{id};
            ApplicationType application = constructor.newInstance(pObjs);
            return application;
        }
        catch (InvocationTargetException e) {
            Throwable appException = e.getTargetException();
            String message = MessageFormat.format(LNG.get((String)"application.manager.no.creation"), id, appException.getLocalizedMessage());
            throw new ApplicationException(message, appException);
        }
        catch (NoSuchMethodException e) {
            String message = MessageFormat.format(LNG.get((String)"application.manager.bad.configuration"), id);
            throw new ApplicationException(message, e);
        }
        catch (InstantiationException e) {
            String message = MessageFormat.format(LNG.get((String)"application.manager.bad.instanciation"), id);
            throw new ApplicationException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = MessageFormat.format(LNG.get((String)"application.manager.bad.implementation"), id);
            throw new ApplicationException(message, e);
        }
    }

    private CSDKApplication createCSDK1_0Application(String id, Class<? extends IApplication> appClass) throws ApplicationException {
        try {
            ApplicationRegistry reg = this.getApplicationRegistry(id);
            CSDKApplication csdkApplication = new CSDKApplication(reg, appClass);
            return csdkApplication;
        }
        catch (OutOfMemoryError e) {
            String message = MessageFormat.format(LNG.get((String)"application.manager.out.of.memory"), id);
            throw new ApplicationException(message, e);
        }
    }

    public final void delListener(ApplicationManagerListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void finishAllApplications() {
        Enumeration<String> appKeys = this.runningApplications.keys();
        while (appKeys.hasMoreElements()) {
            String key = appKeys.nextElement();
            if (key == null) continue;
            Vector<ApplicationType> running = this.runningApplications.get(key);
            boolean i = false;
            while (running.size() > 0) {
                ApplicationType app = running.get(0);
                this.killApplication(app);
            }
        }
    }

    public final ArrayList<ApplicationRegistry> getAllApplicationRegistries() {
        ArrayList<ApplicationRegistry> list = new ArrayList<ApplicationRegistry>();
        Enumeration<String> e = this.registries.keys();
        while (e.hasMoreElements()) {
            String aid = e.nextElement();
            ApplicationRegistry reg = this.getApplicationRegistry(aid);
            if (reg == null) continue;
            list.add(reg);
        }
        return list;
    }

    public final String[] getApplicationEventQueue(String id) {
        return new String[]{"Applications", id};
    }

    public List<String> getApplicationsFromType(String fileType) {
        if (fileType == null) {
            return null;
        }
        Vector<String> apps = this.fileTypeAssociations.get(fileType);
        return apps;
    }

    public ImageIcon getApplicationIcon(String id) {
        ApplicationRegistry reg = this.getApplicationRegistry(id);
        if (reg == null) {
            return null;
        }
        byte[] icDef = reg.getIconDefinition();
        if (icDef == null) {
            return null;
        }
        return new ImageIcon(icDef);
    }

    public final String[] getApplicationManagerEventQueue() {
        return this.appQueue;
    }

    public ApplicationRegistry getApplicationRegistry(String id) {
        if (this.registries == null) {
            return null;
        }
        return this.registries.get(id);
    }

    public boolean hasApplicationRegistry(String id) {
        if (this.registries == null) {
            return false;
        }
        return this.registries.containsKey(id);
    }

    public ApplicationCategory getApplicationCategory(String id) {
        if (this.categories == null) {
            return null;
        }
        return this.categories.get(id);
    }

    public Hashtable<String, ApplicationCategory> getAllApplicationCategories() {
        return this.categories;
    }

    public final String[] getApplicationEventQueue(ApplicationType application, String[] queue) {
        if (queue == null || queue.length <= 0) {
            String err = "Null or empty queue detected!";
            throw new IllegalArgumentException("Null or empty queue detected!");
        }
        int len = queue.length;
        String[] newQueue = new String[len + 2];
        newQueue[0] = "Applications";
        newQueue[1] = application.getId();
        for (int i = 0; i < len; ++i) {
            newQueue[i + 2] = queue[i];
        }
        return newQueue;
    }

    public final int getInstanceIndex(ApplicationType app) {
        String id = app.getId();
        Vector<ApplicationType> running = this.runningApplications.get(id);
        if (running == null) {
            return -1;
        }
        return running.indexOf(app) + 1;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final Hashtable<String, Vector<ApplicationType>> getRunningApplications() {
        return this.runningApplications;
    }

    public final boolean hasRunningApplications() {
        Enumeration<String> appKeys = this.runningApplications.keys();
        while (appKeys.hasMoreElements()) {
            Vector<ApplicationType> running;
            String key = appKeys.nextElement();
            if (key == null || (running = this.runningApplications.get(key)).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public Vector<ApplicationType> getRunningApplications(String id) {
        return this.runningApplications.get(id);
    }

    public boolean isAnyApplicationRunning(String id) {
        Vector<ApplicationType> running = this.runningApplications.get(id);
        return running != null && !running.isEmpty();
    }

    public boolean isApplicationRunning(ApplicationType app) {
        Vector<ApplicationType> running = this.runningApplications.get(app.getId());
        if (running == null) {
            return false;
        }
        return running.contains(app);
    }

    public boolean killApplication(ApplicationType app) {
        try {
            this.setAsDead(app);
            app.killApplication();
            app.finishApplication();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void notifyDeath(ApplicationType app) {
        this.setAsDead(app);
    }

    public void runApplication(ApplicationType application) throws ApplicationException {
        application.launchApplication();
        this.setAsRunning(application);
    }

    public final <A extends ApplicationType> A runApplication(String id) throws ApplicationException {
        if (id == null) {
            String err = "application null";
            throw new ApplicationException("application null");
        }
        ApplicationRegistry reg = this.getApplicationRegistry(id);
        try {
            ApplicationType app;
            try {
                app = this.createApplicationType(id);
            }
            catch (ApplicationCacheCorrupted e) {
                try {
                    ApplicationCache.clearCacheForApplication(reg);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                app = this.createApplicationType(id);
            }
            this.runApplication(app);
            app.postInitialization();
            return (A)app;
        }
        catch (ApplicationUpdatedException e) {
            String msg = String.format(LNG.get((String)"application.manager.updated.program"), reg.getApplicationName(this.getLocale()));
            StandardDialogs.showInfoDialog(null, (String)id, (Object)msg);
            return null;
        }
        catch (Exception e) {
            String msg = String.format(LNG.get((String)"application.manager.failed.program"), id);
            EventLogProxy.addClientInformation(this.appQueue, new String[]{msg});
            throw new ApplicationException(msg, e);
        }
    }

    public <A extends ApplicationType> A runApplication(Class<A> clazz) throws ApplicationException {
        String id = this.getApplicationId(clazz);
        return this.runApplication(id);
    }

    private void setAsDead(ApplicationType app) {
        String id = app.getId();
        Vector<ApplicationType> running = this.runningApplications.get(id);
        if (running != null && running.contains(app)) {
            running.remove(app);
        }
        for (ApplicationManagerListener lst : this.listeners) {
            lst.applicationEnded(id);
        }
    }

    private void setAsRunning(ApplicationType app) {
        String id = app.getId();
        Vector<ApplicationType> running = this.runningApplications.get(id);
        if (running == null) {
            this.runningApplications.put(id, new Vector());
            running = this.runningApplications.get(id);
        }
        ApplicationRegistry registry = app.getApplicationRegistry();
        if (!running.contains(app) || !registry.isSingleton()) {
            running.add(app);
        }
        for (ApplicationManagerListener lst : this.listeners) {
            lst.applicationStarted(id);
        }
    }

    public void setProjectFlag(boolean hasProject) {
        if (this.registries == null) {
            return;
        }
        for (ApplicationRegistry reg : this.registries.values()) {
            if (reg == null) continue;
            String aid = reg.getId();
            InternalStructure structure = this.getInternalStructure(aid);
            ApplicationLink lnk = structure.getLink();
            AbstractAction ac = structure.getAction();
            boolean enable = this.canEnableApplication(hasProject, reg);
            if (lnk != null) {
                lnk.setEnabled(enable);
            }
            if (ac == null) continue;
            ac.setEnabled(enable);
        }
    }

    public final ApplicationLink getApplicationLink(ApplicationRegistry reg) {
        return this.structures.get(reg.getId()).getLink();
    }

    public final String getClassInternalPath(ApplicationRegistry reg, String relativePath) {
        String fullPackageName = this.getApplicationFullPackageName(reg);
        String classPath = fullPackageName.replace('.', '/');
        String resPath = classPath + "/" + relativePath;
        return resPath;
    }

    public final String getApplicationFullPackageName(ApplicationRegistry reg) {
        String className = reg.getClassName();
        if (className == null) {
            String err = "null class name for registry!";
            throw new IllegalStateException("null class name for registry!");
        }
        int idx = className.lastIndexOf(".");
        if (idx == -1) {
            String err = "Application class is not inside a module package!";
            throw new IllegalStateException("Application class is not inside a module package!");
        }
        String fullPackageName = className.substring(0, idx);
        return fullPackageName;
    }

    public final String getApplicationPackageName(ApplicationRegistry reg) {
        String fullPackageName = this.getApplicationFullPackageName(reg);
        int lastIndexOf = fullPackageName.lastIndexOf(".");
        if (lastIndexOf < 0) {
            return "";
        }
        String packageName = fullPackageName.substring(lastIndexOf + 1);
        return packageName;
    }

    public final AbstractAction getApplicationAction(ApplicationRegistry reg) {
        if (reg == null) {
            return null;
        }
        String id = reg.getId();
        InternalStructure structure = this.getInternalStructure(id);
        AbstractAction action = structure.getAction();
        return action;
    }

    public final ActionListener getApplicationActionListener(ApplicationRegistry reg) {
        if (reg == null) {
            return null;
        }
        String id = reg.getId();
        InternalStructure structure = this.getInternalStructure(id);
        AbstractAction actionListener = structure.getAction();
        return actionListener;
    }

    private ApplicationManager(Locale locale) throws RemoteException {
        this.locale = locale;
        this.registries = this.loadApplicationRegistries();
        this.categories = this.loadApplicationCategories();
        this.buildFileTypesAssociations();
        this.setProjectFlag(false);
    }

    private Hashtable<String, ApplicationRegistry> loadApplicationRegistries() throws RemoteException {
        ApplicationServiceInterface appService = ClientRemoteLocator.applicationService;
        if (appService == null) {
            return null;
        }
        Hashtable regs = appService.getApplicationRegistries();
        for (ApplicationRegistry reg : regs.values()) {
            this.loadBundles(reg, this.getClass());
            String id = reg.getId();
            ApplicationStartAction action = new ApplicationStartAction(reg, this.locale);
            ApplicationLink link = new ApplicationLink(action);
            InternalStructure structure = new InternalStructure(action, link);
            this.structures.put(id, structure);
        }
        return regs;
    }

    private Hashtable<String, ApplicationCategory> loadApplicationCategories() throws RemoteException {
        ApplicationServiceInterface appService = ClientRemoteLocator.applicationService;
        if (appService == null) {
            throw new IllegalStateException("ApplicationService not found or loaded");
        }
        Hashtable cats = appService.getApplicationCategories();
        return cats;
    }

    public String getApplicationName(ApplicationRegistry applicationRegistry) {
        return applicationRegistry.getApplicationName(this.locale);
    }

    public String getCategoryName(ApplicationCategory category) {
        return category.getCategoryName(this.locale);
    }

    public String getApplicationDescription(ApplicationRegistry applicationRegistry) {
        return applicationRegistry.getApplicationDescription(this.locale);
    }

    public String getApplicationId(Class<? extends ApplicationType> clazz) {
        String className = clazz.getName();
        Set<Map.Entry<String, ApplicationRegistry>> entries = this.registries.entrySet();
        for (Map.Entry<String, ApplicationRegistry> entry : entries) {
            ApplicationRegistry reg = entry.getValue();
            if (!className.equals(reg.getClassName())) continue;
            return reg.getId();
        }
        return null;
    }

    public final JMenu buildCategoryMenu(ApplicationCategory cat) {
        JMenu menu = new JMenu();
        ArrayList ids = cat.getApplicationIds();
        for (String id : ids) {
            ApplicationRegistry reg = this.getApplicationRegistry(id);
            if (!reg.isShownAtApplicationMenu()) continue;
            AbstractAction action = this.getApplicationAction(reg);
            menu.add(action);
        }
        menu.setText(cat.getCategoryName(this.locale));
        byte[] ic = cat.getIcon();
        if (ic != null) {
            menu.setIcon(new ImageIcon(ic));
        }
        return menu;
    }

    public InputStream getApplicationResource(Window parent, final ApplicationRegistry appRegistry, final String[] resourcePath) {
        if (appRegistry == null) {
            throw new IllegalArgumentException("appRegistry n\u00e3o pode ser nulo.");
        }
        if (resourcePath == null || resourcePath.length == 0) {
            throw new IllegalArgumentException("resourcePath deve ter ao menos um elemento que define o arquivo buscado.");
        }
        final ApplicationServiceInterface appService = ClientRemoteLocator.applicationService;
        Task<InputStream> task = new Task<InputStream>(){

            protected void performTask() {
                try {
                    RemoteFileChannelInfo info = appService.getApplicationResource(appRegistry.getId(), resourcePath);
                    if (info != null) {
                        RemoteFileInputStream in = new RemoteFileInputStream(info);
                        this.setResult(in);
                    }
                }
                catch (Exception e) {
                    this.setResult(null);
                }
            }
        };
        task.execute(parent, this.getApplicationName(appRegistry), LNG.get((String)"application.manager.task.body"));
        return (InputStream)task.getResult();
    }

    public final boolean isFavoriteApplication(String id) {
        List<String> ids = this.getFavoriteApplications();
        return ids.contains(id);
    }

    public final List<String> getFavoriteApplications() {
        PVList pv = this.getFavorites();
        List valuesIds = (List)pv.getValue();
        ArrayList<String> ids = new ArrayList<String>();
        for (String valueId : valuesIds) {
            ApplicationRegistry reg = this.getApplicationRegistry(valueId);
            if (reg == null) continue;
            ids.add(valueId);
        }
        Collections.unmodifiableList(ids);
        return ids;
    }

    private PVList getFavorites() {
        PreferenceManager pm = PreferenceManager.getInstance();
        PreferenceCategory root = pm.loadPreferences();
        PreferenceCategory pc = root.getCategory(DesktopPref.class);
        DesktopPref fav = DesktopPref.FAVORITE_APPLICATIONS;
        PVList pv = (PVList)pc.getPreference(fav);
        return pv;
    }

    public final void addAsFavoriteApplication(String id) {
        ApplicationRegistry reg = this.getApplicationRegistry(id);
        if (reg == null) {
            return;
        }
        List<String> ids = this.getFavoriteApplications();
        if (ids.contains(id)) {
            return;
        }
        ids.add(id);
        PVList fav = this.getFavorites();
        fav.setValue(ids);
    }

    public final void delAsFavoriteApplication(String id) {
        ApplicationRegistry reg = this.getApplicationRegistry(id);
        if (reg == null) {
            return;
        }
        List<String> ids = this.getFavoriteApplications();
        if (!ids.contains(id)) {
            return;
        }
        PVList fav = this.getFavorites();
        ids.remove(id);
        fav.setValue(ids);
    }

    public ApplicationType getApplicationInstance(String id) {
        for (Vector<ApplicationType> instances : this.runningApplications.values()) {
            for (ApplicationType app : instances) {
                if (!app.getInstanceId().equals(id)) continue;
                return app;
            }
        }
        return null;
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                instance = null;
            }
        });
    }
}

