/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskinfo;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.diskinfo.DiskInfoPanel;
import csbase.client.applications.diskinfo.DiskProjectPanel;
import csbase.client.applications.diskinfo.DiskSpacePanel;
import csbase.client.applications.diskinfo.DiskUserPanel;
import csbase.exception.BugException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import tecgraf.javautils.core.lng.LNG;

public class DiskInfo
extends Application {
    private ApplicationFrame mainFrame = null;
    private final List<DiskInfoPanel> monitoringPanels;
    private DiskUserPanel uPanel;
    private DiskSpacePanel pPanel;
    private DiskProjectPanel prjPanel;
    private final JCheckBox animationToggle = new JCheckBox();
    private Timer updateTimer = null;

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildOptionsMenu());
        menuBar.add(new JPanel());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    private JMenu buildOptionsMenu() {
        JMenu optMenu = new JMenu(this.getString("menu.options"));
        JMenuItem updItem = optMenu.add(this.getString("menu.options.update"));
        updItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskInfo.this.refreshPies();
            }
        });
        updItem.setIcon(ApplicationImages.ICON_REFRESH_16);
        optMenu.addSeparator();
        optMenu.add(new ApplicationExitAction(this));
        return optMenu;
    }

    private JMenu buildHelpMenu() {
        JMenu aboutMenu = new JMenu(this.getString("menu.help"));
        aboutMenu.add(new ApplicationAboutAction(this));
        return aboutMenu;
    }

    private ApplicationFrame createMainFrame() {
        this.animationToggle.setText(this.getString("toggle.animation"));
        ApplicationFrame frame = this.getApplicationFrame();
        Container cp = frame.getContentPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        if (this.monitoringPanels.size() > 1) {
            JTabbedPane tabbedPane = new JTabbedPane();
            for (DiskInfoPanel p : this.monitoringPanels) {
                tabbedPane.add(p);
            }
            panel.add((Component)tabbedPane, "Center");
        } else {
            panel.add((Component)this.monitoringPanels.get(0), "Center");
        }
        JToolBar optionPanel = new JToolBar(0);
        JButton refButton = new JButton();
        refButton.setToolTipText(this.getString("tooltip.refresh"));
        refButton.setText(null);
        refButton.setIcon(ApplicationImages.ICON_REFRESH_16);
        refButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DiskInfo.this.refreshPies();
            }
        });
        optionPanel.add(refButton);
        optionPanel.add(new JPanel());
        optionPanel.add(this.animationToggle);
        panel.add((Component)optionPanel, "North");
        cp.add(panel);
        return frame;
    }

    public void start() {
        this.mainFrame.pack();
    }

    @Override
    public void killApplication() {
        this.updateTimer.stop();
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    private void rotatePies() {
        if (!this.animationToggle.isSelected()) {
            return;
        }
        for (DiskInfoPanel p : this.monitoringPanels) {
            p.rotatePie();
        }
    }

    private void refreshPies() {
        for (DiskInfoPanel p : this.monitoringPanels) {
            p.refreshPie(this);
        }
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, LNG.getLocale());
        this.getApplicationFrame().getStatusBar().setStatus(df.format(new Date()));
    }

    private void createUpdateTimer() {
        int delay = 1000;
        ActionListener updateTask = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskInfo.this.rotatePies();
            }
        };
        this.updateTimer = new Timer(1000, updateTask);
        this.updateTimer.start();
    }

    public DiskInfo(String id) throws BugException {
        super(id);
        this.monitoringPanels = new ArrayList<DiskInfoPanel>();
        if (this.getBooleanSpecificProperty("hasUserPanel", true)) {
            this.uPanel = new DiskUserPanel(this);
            this.monitoringPanels.add(this.uPanel);
        } else {
            this.uPanel = null;
        }
        if (this.getBooleanSpecificProperty("hasSpacePanel", false)) {
            this.pPanel = new DiskSpacePanel(this);
            this.monitoringPanels.add(this.pPanel);
        } else {
            this.pPanel = null;
        }
        if (this.getBooleanSpecificProperty("hasProjectPanel", false)) {
            this.prjPanel = new DiskProjectPanel(this);
            this.monitoringPanels.add(this.prjPanel);
        } else {
            this.prjPanel = null;
        }
        if (this.monitoringPanels.size() == 0) {
            throw new BugException("Nenhum tipo de monitora\u00e7\u00e3o foi configurado");
        }
        this.mainFrame = this.createMainFrame();
        this.mainFrame.setJMenuBar(this.buildMenuBar());
        this.start();
        this.refreshPies();
        this.createUpdateTimer();
    }
}

