/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphLayout;
import csbase.client.applications.flowapplication.graph.GraphNode;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public class UniformSizeGraphLayout
implements GraphLayout {
    @Override
    public void doLayout(Graph graph) {
        double newWidth = 0.0;
        double newHeight = 0.0;
        Collection<GraphNode> nodeCollection = graph.getNodeCollection();
        for (GraphNode node : nodeCollection) {
            Dimension minimumSize = node.getMinimumSize();
            newWidth = Math.max(minimumSize.getWidth(), newWidth);
            newHeight = Math.max(minimumSize.getHeight(), newHeight);
        }
        for (GraphNode node : nodeCollection) {
            Rectangle2D previousBounds = node.getBounds2D();
            double centerX = previousBounds.getCenterX();
            double centerY = previousBounds.getCenterY();
            node.setBounds2D(node.getX(), node.getY(), newWidth, newHeight);
            node.setLocation(new Point2D.Double(centerX, centerY));
        }
    }

    @Override
    public boolean canApplyLayout(Graph graph) {
        return true;
    }
}

