/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.RemoveUsersTask;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.RetrieveUsersTask;
import csbase.client.applications.projectsmanager.usersearch.UserDialog;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class RemoveUsersAction
extends ProjectsManagerAction {
    public RemoveUsersAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() == 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        List<UserOutline> usersInProjects = this.getAllUsersInProjects(projects);
        String title = this.getString("RemoveUsersAction.selection.title");
        Set<Object> ids = UserDialog.showUserSelectionDialog(projectsManager.getApplicationFrame(), usersInProjects, true, title);
        if (ids == null) {
            return;
        }
        this.runTask(projects, ids);
        projectsManager.refreshProjectsTable();
        projectsManager.refreshInfoPanel();
    }

    private void runTask(List<ProjectsManagerData> projects, Set<Object> ids) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        RemoveUsersTask rut = new RemoveUsersTask(projectsManager, projects, ids);
        ApplicationFrame frame = appFrame;
        rut.execute(frame, this.getString("RemoveUsersAction.title"), this.getString("RemoveUsersAction.message"));
        if (rut.wasCancelled()) {
            String err = this.getString("RemoveUsersAction.cancelled.message");
            rut.showError(err);
            return;
        }
        if (!rut.getStatus()) {
            Exception exception = rut.getError();
            throw exception;
        }
    }

    private List<UserOutline> getAllUsersInProjects(List<ProjectsManagerData> projectList) throws Exception {
        HashSet<Object> usersInProjects = new HashSet<Object>();
        for (ProjectsManagerData pmd : projectList) {
            Set<Object> usersRO = pmd.getUsersRO();
            Set<Object> usersRW = pmd.getUsersRW();
            if (usersRO != null) {
                usersInProjects.addAll(usersRO);
            }
            if (usersRW == null) continue;
            usersInProjects.addAll(usersRW);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        RetrieveUsersTask rut = new RetrieveUsersTask(this.getProjectsManager(), usersInProjects);
        rut.execute(frame, "", "");
        if (rut.wasCancelled()) {
            String err = this.getString("RemoveUsersAction.cancelled.message");
            rut.showError(err);
            return null;
        }
        if (!rut.getStatus()) {
            Exception exception = rut.getError();
            throw exception;
        }
        List users = (List)rut.getResult();
        return users;
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ProjectsManagerUI.REMOVE_SHARED;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            ProjectsManagerScope scope = pmd.getScope();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            if (spaceAllocation.isOpenable() && (isAdmin || isOwner) && scope == ProjectsManagerScope.SHARED) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = this.getString("RemoveUsersAction.project.selection.denied.message") + this.getString("RemoveUsersAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("RemoveUsersAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = this.getString("RemoveUsersAction.project.selection.some.denied.message") + this.getString("RemoveUsersAction.project.requirements.message"), prjList, this.getString("RemoveUsersAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }
}

