/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.List;

public class SetProjectSharingStatsTask
extends ProjectsManagerTask<Boolean> {
    private List<ProjectsManagerData> projects;
    private ProjectsManagerScope scope;
    private ProjectPermissions.SharingType accessType;

    public SetProjectSharingStatsTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, ProjectsManagerScope scope, ProjectPermissions.SharingType accessType) {
        super(projectsManager);
        this.projects = projects;
        this.scope = scope;
        this.accessType = accessType;
    }

    protected void performTask() throws RemoteException {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        if (this.scope == ProjectsManagerScope.PRIVATE) {
            for (ProjectsManagerData prj : this.projects) {
                CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
                if (ccp == null) {
                    this.setResult(false);
                    return;
                }
                ccp.makePrivate();
                ProjectsManagerUI.addAutomaticHistoryBlock(ccp, ProjectHistoryBlockType.PROJECT_PRIVATE);
                ccp.close(true);
            }
        } else if (this.scope == ProjectsManagerScope.PUBLIC) {
            for (ProjectsManagerData prj : this.projects) {
                CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
                if (ccp == null) continue;
                ccp.makePublic(this.accessType == ProjectPermissions.SharingType.ALL_RO);
                ProjectsManagerUI.addAutomaticHistoryBlock(ccp, ProjectHistoryBlockType.PROJECT_PUBLIC);
                ccp.close(true);
            }
        }
        this.setResult(true);
    }
}

