/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.statsviewer;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.calendar.CalendarDateField;

public class SearchPanel
extends JPanel {
    private JRadioButton loginRadio;
    private JRadioButton applicationsRadio;
    private JRadioButton executionsRadio;
    private JComboBox selectTimeCombo;
    private CalendarDateField startDateCalendar;
    private CalendarDateField endDateCalendar;
    private JLabel divLabel;
    private JButton searchButton;
    private JButton newsearchButton;
    private JButton exportCSVButton;
    private JRadioButton byYearButton;
    private JRadioButton byMonthButton;
    private JRadioButton byDayButton;
    private final StatsViewer appViewer;

    public SearchPanel(StatsViewer appViewer) {
        super(new GridBagLayout());
        this.appViewer = appViewer;
        GBC gbc = new GBC(0, 0).northwest().insets(5).horizontal();
        this.add((Component)this.buildStatsPanel(), gbc);
        gbc = new GBC(0, 1).northwest().insets(5).horizontal();
        this.add((Component)this.buildTimePanel(), gbc);
        gbc = new GBC(0, 2).northwest().insets(5).horizontal();
        this.add((Component)this.buildButtonsPanel(), gbc);
        gbc = new GBC(0, 3).northwest().insets(5).horizontal();
        this.add((Component)this.buildFilterDatePanel(), gbc);
        this.selectTimeCombo.setSelectedIndex(TimeType.PreviousYear.ordinal());
    }

    private JPanel buildStatsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(this.appViewer.getString("statsPanel.title")));
        this.loginRadio = new JRadioButton(this.appViewer.getString("statsLogin"), true);
        this.loginRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.appViewer.setLogType(LogsView.LogsDataType.LoginData);
            }
        });
        this.applicationsRadio = new JRadioButton(this.appViewer.getString("statsApplications"));
        this.applicationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.appViewer.setLogType(LogsView.LogsDataType.ApplicationsData);
            }
        });
        this.executionsRadio = new JRadioButton(this.appViewer.getString("statsExecutions"));
        this.executionsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.appViewer.setLogType(LogsView.LogsDataType.ExecutionsData);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.loginRadio);
        group.add(this.applicationsRadio);
        group.add(this.executionsRadio);
        GBC gbc = new GBC(0, 0).insets(5, 5, 0, 5).northwest().pushx();
        panel.add((Component)this.loginRadio, gbc);
        gbc = new GBC(0, 1).insets(0, 5, 0, 5).northwest();
        panel.add((Component)this.applicationsRadio, gbc);
        gbc = new GBC(0, 2).insets(0, 5, 0, 5).northwest();
        panel.add((Component)this.executionsRadio, gbc);
        this.appViewer.setLogType(LogsView.LogsDataType.LoginData);
        return panel;
    }

    private JPanel buildTimePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(this.appViewer.getString("statsPanel.time.title")));
        ArrayList<String> items = new ArrayList<String>();
        for (TimeType time : TimeType.values()) {
            items.add(this.appViewer.getString(time.name()));
        }
        this.selectTimeCombo = new JComboBox<Object>(items.toArray());
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{this.selectTimeCombo});
        this.selectTimeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.newSelectedTime();
            }
        });
        GBC gbc = new GBC(0, 0).northwest().width(3).insets(10, 10, 0, 5);
        panel.add((Component)this.selectTimeCombo, gbc);
        this.startDateCalendar = new CalendarDateField();
        gbc = new GBC(0, 1).northwest().insets(10, 10, 5, 0).horizontal();
        panel.add((Component)this.startDateCalendar, gbc);
        this.divLabel = new JLabel("-");
        gbc = new GBC(1, 1).center().insets(10, 5, 5, 5);
        panel.add((Component)this.divLabel, gbc);
        this.endDateCalendar = new CalendarDateField();
        gbc = new GBC(2, 1).northwest().insets(10, 5, 5, 5).horizontal();
        panel.add((Component)this.endDateCalendar, gbc);
        return panel;
    }

    private void newSelectedTime() {
        TimeType selected = TimeType.values()[this.selectTimeCombo.getSelectedIndex()];
        boolean isCustom = selected.equals((Object)TimeType.Custom);
        this.startDateCalendar.setEnabled(isCustom);
        this.divLabel.setEnabled(isCustom);
        this.endDateCalendar.setEnabled(isCustom);
        Calendar calendar = Calendar.getInstance();
        switch (selected) {
            case PreviousMonth: {
                calendar.add(2, -1);
                this.startDateCalendar.setDate(calendar.getTime());
                calendar.add(2, 1);
                this.endDateCalendar.setDate(calendar.getTime());
                break;
            }
            case PreviousSixMonth: {
                calendar.add(2, -6);
                this.startDateCalendar.setDate(calendar.getTime());
                calendar.add(2, 6);
                this.endDateCalendar.setDate(calendar.getTime());
                break;
            }
            case PreviousYear: {
                calendar.add(1, -1);
                this.startDateCalendar.setDate(calendar.getTime());
                calendar.add(1, 1);
                this.endDateCalendar.setDate(calendar.getTime());
                break;
            }
            case PreviousThreeYear: {
                calendar.add(1, -3);
                this.startDateCalendar.setDate(calendar.getTime());
                calendar.add(1, 3);
                this.endDateCalendar.setDate(calendar.getTime());
                break;
            }
        }
        this.updatedTimeType(selected);
    }

    private JPanel buildButtonsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.searchButton = new JButton(new AbstractAction(this.appViewer.getString("search")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchPanel.this.validateSearch()) {
                    return;
                }
                SearchPanel.this.searchButton.setEnabled(false);
                SearchPanel.this.selectTimeCombo.setEnabled(false);
                SearchPanel.this.startDateCalendar.setEnabled(false);
                SearchPanel.this.endDateCalendar.setEnabled(false);
                SearchPanel.this.loginRadio.setEnabled(false);
                SearchPanel.this.applicationsRadio.setEnabled(false);
                SearchPanel.this.executionsRadio.setEnabled(false);
                SearchPanel.this.appViewer.find(SearchPanel.this.startDateCalendar.getDate(), SearchPanel.this.endDateCalendar.getDate());
                SearchPanel.this.newsearchButton.setEnabled(true);
                SearchPanel.this.exportCSVButton.setEnabled(true);
            }
        });
        this.newsearchButton = new JButton(new AbstractAction(this.appViewer.getString("newsearch")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.newsearchButton.setEnabled(false);
                SearchPanel.this.exportCSVButton.setEnabled(false);
                SearchPanel.this.appViewer.clearInfo();
                SearchPanel.this.searchButton.setEnabled(true);
                SearchPanel.this.selectTimeCombo.setEnabled(true);
                SearchPanel.this.startDateCalendar.setEnabled(true);
                SearchPanel.this.endDateCalendar.setEnabled(true);
                SearchPanel.this.loginRadio.setEnabled(true);
                SearchPanel.this.applicationsRadio.setEnabled(true);
                SearchPanel.this.executionsRadio.setEnabled(true);
            }
        });
        this.exportCSVButton = new JButton(new AbstractAction(this.appViewer.getString("export.csv")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchPanel.this.appViewer.exportCSV();
            }
        });
        this.newsearchButton.setEnabled(false);
        this.exportCSVButton.setEnabled(false);
        panel.add((Component)this.searchButton, new GBC(0, 0).insets(10, 0, 10, 0));
        panel.add((Component)this.newsearchButton, new GBC(1, 0).insets(10, 10, 10, 0));
        panel.add((Component)this.exportCSVButton, new GBC(0, 1).insets(10, 10, 10, 0).width(2));
        return panel;
    }

    private boolean validateSearch() {
        if (this.startDateCalendar.isEnabled() && this.startDateCalendar.getDate() == null) {
            StandardDialogs.showInfoDialog((Component)this.appViewer.getApplicationFrame(), (String)this.appViewer.getString("warning.title"), (Object)this.appViewer.getString("noStartDate"));
            return false;
        }
        if (this.endDateCalendar.isEnabled() && this.endDateCalendar.getDate() == null) {
            StandardDialogs.showInfoDialog((Component)this.appViewer.getApplicationFrame(), (String)this.appViewer.getString("warning.title"), (Object)this.appViewer.getString("noEndDate"));
            return false;
        }
        return true;
    }

    private JPanel buildFilterDatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(this.appViewer.getString("filterPanel.title")));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.appViewer.filterDateViewType(SearchPanel.this.getDateViewType());
            }
        };
        this.byYearButton = new JRadioButton(this.appViewer.getString("filterPanel.byYearButton"));
        this.byYearButton.addActionListener(listener);
        this.byMonthButton = new JRadioButton(this.appViewer.getString("filterPanel.byMonthButton"));
        this.byMonthButton.addActionListener(listener);
        this.byDayButton = new JRadioButton(this.appViewer.getString("filterPanel.byDayButton"));
        this.byDayButton.addActionListener(listener);
        ButtonGroup detailGroup = new ButtonGroup();
        detailGroup.add(this.byYearButton);
        detailGroup.add(this.byMonthButton);
        detailGroup.add(this.byDayButton);
        GBC gbc = new GBC(0, 0).insets(0, 5, 5, 0).northwest();
        panel.add((Component)this.byYearButton, gbc);
        gbc = new GBC(1, 0).insets(0, 5, 5, 0).northwest();
        panel.add((Component)this.byMonthButton, gbc);
        gbc = new GBC(2, 0).insets(0, 5, 5, 5).northwest().pushy();
        panel.add((Component)this.byDayButton, gbc);
        return panel;
    }

    private void updatedTimeType(TimeType selectedTime) {
        switch (selectedTime) {
            case PreviousMonth: {
                this.byDayButton.setSelected(true);
                this.byDayButton.setEnabled(true);
                this.byMonthButton.setEnabled(false);
                this.byYearButton.setEnabled(false);
                break;
            }
            case PreviousSixMonth: {
                this.byMonthButton.setSelected(true);
                this.byDayButton.setEnabled(true);
                this.byMonthButton.setEnabled(true);
                this.byYearButton.setEnabled(false);
                break;
            }
            case PreviousYear: {
                this.byMonthButton.setSelected(true);
                this.byDayButton.setEnabled(true);
                this.byMonthButton.setEnabled(true);
                this.byYearButton.setEnabled(true);
                break;
            }
            case PreviousThreeYear: 
            case Custom: {
                this.byYearButton.setSelected(true);
                this.byDayButton.setEnabled(true);
                this.byMonthButton.setEnabled(true);
                this.byYearButton.setEnabled(true);
            }
        }
        this.appViewer.filterDateViewType(this.getDateViewType());
    }

    public LogsView.DateViewType getDateViewType() {
        if (this.byYearButton.isSelected()) {
            return LogsView.DateViewType.YEAR;
        }
        if (this.byMonthButton.isSelected()) {
            return LogsView.DateViewType.MONTH;
        }
        return LogsView.DateViewType.DAY;
    }

    public static enum TimeType {
        Custom,
        PreviousMonth,
        PreviousSixMonth,
        PreviousYear,
        PreviousThreeYear;

    }
}

