/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.Client;
import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.ias.Filter;
import csbase.client.ias.UserPermissionDefinitionDialog;
import csbase.client.ias.UserRoleDefinitionDialog;
import csbase.client.kernel.ClientException;
import csbase.client.project.ClientProjectFileType;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectTreePath;
import csbase.client.remote.srvproxies.UserGroupProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.logic.UserInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;
import tecgraf.javautils.parsers.tsv.TsvParser;

public final class ImportUsersDialog {
    private static final String EMAILS_SPLIT_REGEX = "[,;\\s]+";
    private static final Class<?>[] COL_CLASSES = new Class[]{String.class, String.class, String.class, String.class};
    private static final String[] COL_NAMES = new String[]{LNG.get((String)"IAS_USER"), LNG.get((String)"IAS_USER_NAME"), LNG.get((String)"IAS_USER_EMAIL"), LNG.get((String)"IAS_USERGROUP")};
    private final Window owner;
    private final String windowTitle;
    private final DesktopComponentDialog window;
    private JButton roleButton;
    private JButton permissionButton;
    private JButton actionButton;
    private JTextField filePath;
    private final Container contentPane;
    private ClientFile currentFile;
    private SortableTable sortableTable;
    private ObjectTableModel<String[]> tableModel;
    private final UserRoleDefinitionDialog userRoleDefinitionDialog;
    private final UserPermissionDefinitionDialog userPermissionDefinitionDialog;
    private final UserInfo defaultUserInfo;
    private static final String FILE_TYPE = "CSV";
    private static final int COLUMN_COUNT = 4;
    private static final int LOGIN_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int E_MAIL_COLUMN = 2;
    private static final int USERGROUP_COLUMN = 3;
    private final List<String> insertedUserList = new ArrayList<String>();
    private final List<String> discartedUserList = new ArrayList<String>();
    private final List<String> editedUserList = new ArrayList<String>();

    private void createActionButton() {
        this.actionButton = new JButton(LNG.get((String)"IAS_IMPORT_USERS_ACTION_BUTTON"));
        this.actionButton.setEnabled(false);
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteTask<ImportResults> remoteTask = new RemoteTask<ImportResults>(){

                    protected void performTask() throws Exception {
                        this.setResult((Object)ImportUsersDialog.this.importUsers());
                    }
                };
                remoteTask.execute(ImportUsersDialog.this.window, ImportUsersDialog.this.windowTitle, LNG.get((String)"IAS_WAITING_USER_IMPORTING"));
                ImportResults result = (ImportResults)((Object)remoteTask.getResult());
                if (result == ImportResults.NONE_IMPORTED) {
                    StandardDialogs.showErrorDialog((Component)ImportUsersDialog.this.window, (String)LNG.get((String)"IAS_IMPORT_USERS_TITLE"), (String)LNG.get((String)"IAS_IMPORT_ALL_FAILED"));
                } else {
                    if (result == ImportResults.SOME_IMPORTED) {
                        StandardDialogs.showWarningDialog((Component)ImportUsersDialog.this.window, (String)LNG.get((String)"IAS_IMPORT_USERS_TITLE"), (String)LNG.get((String)"IAS_IMPORT_SOME_FAILED"));
                    }
                    ImportedUserDialog importedUserDialog = new ImportedUserDialog(ImportUsersDialog.this.window, ImportUsersDialog.this.insertedUserList, ImportUsersDialog.this.editedUserList, ImportUsersDialog.this.discartedUserList);
                    importedUserDialog.showDialog();
                }
                ImportUsersDialog.this.insertedUserList.clear();
                ImportUsersDialog.this.discartedUserList.clear();
                ImportUsersDialog.this.editedUserList.clear();
            }
        });
    }

    private void createButtonPanel() {
        this.createRoleButton();
        this.createPermissionButton();
        this.createActionButton();
        JButton closeButton = this.createCloseButton();
        ClientUtilities.adjustEqualSizes(this.roleButton, this.permissionButton, this.actionButton, closeButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.roleButton);
        buttonsPanel.add(this.permissionButton);
        buttonsPanel.add(this.actionButton);
        buttonsPanel.add(closeButton);
        this.contentPane.add((Component)buttonsPanel, "South");
    }

    private JButton createCloseButton() {
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.setEnabled(true);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportUsersDialog.this.window.close();
            }
        });
        return closeButton;
    }

    private void createFileChooserPanel() {
        JPanel fileChooserPanel = new JPanel(new GridBagLayout());
        JLabel theLabel = new JLabel(LNG.get((String)"IAS_USERS_FILE") + ':');
        this.filePath = new JTextField(30);
        this.filePath.setEditable(false);
        JButton findProjButton = this.createFindProjectButton();
        JButton findLocalButton = this.createFindLocalButton();
        fileChooserPanel.add((Component)theLabel, new GBC(0, 0));
        fileChooserPanel.add((Component)this.filePath, new GBC(1, 0).horizontal().insets(0, 5, 0, 0));
        fileChooserPanel.add((Component)findProjButton, new GBC(2, 0).insets(0, 10, 0, 0));
        fileChooserPanel.add((Component)findLocalButton, new GBC(3, 0).insets(0, 5, 0, 0));
        BorderUtil.setEtchedBorder((JComponent)fileChooserPanel, null);
        this.contentPane.add((Component)fileChooserPanel, "North");
    }

    private JButton createFindLocalButton() {
        JButton findButton = ClientUtilities.createImageButton(ApplicationImages.ICON_OPEN_LOCAL_16);
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImportUsersDialog.this.showFileChooser();
            }
        });
        return findButton;
    }

    private JButton createFindProjectButton() {
        JButton findButton = ClientUtilities.createImageButton(ApplicationImages.ICON_OPEN_16);
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImportUsersDialog.this.showProjectFileChooser();
            }
        });
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame == null || desktopFrame.getProject() == null) {
            findButton.setEnabled(false);
        }
        return findButton;
    }

    private void createPermissionButton() {
        this.permissionButton = new JButton(LNG.get((String)"IAS_USER_PERMISSIONS_BUTTON"));
        this.permissionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportUsersDialog.this.userPermissionDefinitionDialog.showDialog();
            }
        });
    }

    private void createRoleButton() {
        this.roleButton = new JButton(LNG.get((String)"IAS_USER_ROLES_BUTTON"));
        this.roleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportUsersDialog.this.userRoleDefinitionDialog.showDialog();
            }
        });
    }

    private void createTable() {
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                String[] stringArray;
                Object[] line = (Object[])item;
                if (line == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = (String)line[0];
                    stringArray2[1] = (String)line[1];
                    stringArray2[2] = (String)line[2];
                    stringArray = stringArray2;
                    stringArray2[3] = (String)line[3];
                }
                return stringArray;
            }

            public Class<?>[] getColumnClasses() {
                return COL_CLASSES;
            }

            public String[] getColumnNames() {
                return COL_NAMES;
            }
        };
        this.tableModel = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)provider);
        this.sortableTable = new SortableTable(this.tableModel);
        this.sortableTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ImportUsersDialog.this.updateActionButton();
            }
        });
    }

    private void createUsersPanel() {
        JPanel usersPanel = new JPanel();
        usersPanel.setLayout(new BorderLayout());
        this.createTable();
        JScrollPane scrollPane = new JScrollPane((Component)this.sortableTable);
        usersPanel.add((Component)scrollPane, "Center");
        BorderUtil.setEtchedBorder((JComponent)usersPanel, null);
        this.contentPane.add((Component)usersPanel, "Center");
    }

    private void importUser(UserInfo newUserInfo) throws Exception {
        User user = User.getUser((Object)newUserInfo.getLogin());
        if (user == null) {
            User.createUser((UserInfo)newUserInfo);
            this.insertedUserList.add(newUserInfo.getLogin());
        } else {
            this.updateUser(user, newUserInfo);
            this.editedUserList.add(user.getUserInfo().getLogin());
        }
    }

    private ImportResults importUsers() throws Exception {
        int[] selectedRows = this.sortableTable.getSelectedRows();
        ArrayList<UserInfo> usersToImport = new ArrayList<UserInfo>();
        for (int selectedRow : selectedRows) {
            String login = (String)this.sortableTable.getValueAt(selectedRow, 0);
            String name = (String)this.sortableTable.getValueAt(selectedRow, 1);
            String emails = (String)this.sortableTable.getValueAt(selectedRow, 2);
            String userGroupName = (String)this.sortableTable.getValueAt(selectedRow, 3);
            UserGroup userGroup = UserGroupProxy.getUserGroupByName(this.window, this.windowTitle, LNG.get((String)"IAS_WAITING_USERGROUP"), userGroupName);
            if (userGroup != null) {
                UserInfo userInfo = new UserInfo(login, name, emails.split(EMAILS_SPLIT_REGEX), (Object[])this.defaultUserInfo.getAttribute("roleIds"), (Object[])this.defaultUserInfo.getAttribute("permissionIds"));
                userInfo.setAttribute("password", (Object)login);
                userInfo.setAttribute("unId", userGroup.getId());
                usersToImport.add(userInfo);
                continue;
            }
            this.discartedUserList.add(login);
        }
        ImportResults result = ImportResults.ALL_IMPORTED;
        if (usersToImport.isEmpty()) {
            return ImportResults.NONE_IMPORTED;
        }
        if (usersToImport.size() < selectedRows.length) {
            result = ImportResults.SOME_IMPORTED;
        }
        for (UserInfo ui : usersToImport) {
            this.importUser(ui);
        }
        return result;
    }

    private void loadDataFromFile(ClientFile file) throws IOException {
        String tskMsg;
        Client client;
        Charset charset;
        final TsvParser tsvParser = new TsvParser();
        final InputStream inputStream = file.getInputStream();
        RemoteTask<String[][]> remoteTask = new RemoteTask<String[][]>(charset = (client = Client.getInstance()).getSystemDefaultCharset()){
            final /* synthetic */ Charset val$charset;
            {
                this.val$charset = charset;
            }

            protected void performTask() throws Exception {
                String[][] fields = tsvParser.parse(inputStream, this.val$charset);
                this.setResult(fields);
            }
        };
        boolean executed = remoteTask.execute(this.window, this.windowTitle, tskMsg = LNG.get((String)"IAS_WAITING_USER_IMPORTING"));
        if (!executed) {
            return;
        }
        String[][] fields = (String[][])remoteTask.getResult();
        int linesRead = 0;
        for (String[] field : fields) {
            if (field.length != 4) continue;
            this.tableModel.add((Object)new String[]{field[0], field[1], field[2], field[3]});
            ++linesRead;
        }
        if (linesRead < fields.length) {
            StandardDialogs.showWarningDialog((Component)this.window, (String)LNG.get((String)"IAS_IMPORT_USERS_TITLE"), (String)LNG.get((String)"IAS_IMPORT_USERS_LOAD_DATA_PARTIAL"));
        }
    }

    private List<Object> merge(Object[] array1, Object[] array2) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (Object element : array1) {
            returnList.add(element);
        }
        for (int i = 0; i < array2.length; ++i) {
            if (returnList.contains(array2[i])) continue;
            returnList.add(array2[i]);
        }
        return returnList;
    }

    public void showDialog() {
        this.createFileChooserPanel();
        this.createUsersPanel();
        this.createButtonPanel();
        this.window.pack();
        this.window.center(this.owner);
        this.window.setVisible(true);
    }

    private void showFileChooser() {
        File file = null;
        try {
            JFileChooser fc = new JFileChooser();
            fc.setAcceptAllFileFilterUsed(true);
            fc.addChoosableFileFilter(new Filter("txt", LNG.get((String)"ias.file_type.txt.description")));
            fc.addChoosableFileFilter(new Filter("csv", LNG.get((String)"ias.file_type.csv.description")));
            int returnVal = fc.showOpenDialog(this.window);
            if (returnVal == 0) {
                file = fc.getSelectedFile();
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.window, this.windowTitle, LNG.get((String)"IAS_IMPORT_USERS_LOAD_DATA_FAILED"));
            return;
        }
        if (file != null) {
            ClientLocalFile clientLocalFile = new ClientLocalFile(file);
            this.updateChosenFile(clientLocalFile);
        }
    }

    private void showProjectFileChooser() {
        ProjectFileChooserOpen chooser;
        try {
            String fileTypeExt = FILE_TYPE;
            ClientProjectFileType projFileType = ClientProjectFileType.getFileType(FILE_TYPE);
            if (projFileType.getCode().equals("UNKNOWN")) {
                fileTypeExt = "TEXT";
            }
            DesktopFrame desktop = DesktopFrame.getInstance();
            CommonClientProject project = desktop.getProject();
            boolean mode = false;
            chooser = new ProjectFileChooserOpen((Window)this.window, project, false, 0, fileTypeExt);
        }
        catch (ClientException e) {
            StandardErrorDialogs.showErrorDialog((Window)this.window, e);
            return;
        }
        ProjectTreePath treePath = chooser.getSelectedPath();
        if (treePath != null) {
            ClientProjectFile clientProjectFile = treePath.getFile();
            this.updateChosenFile((ClientFile)clientProjectFile);
        }
    }

    private void updateActionButton() {
        boolean canEnableActionButton = false;
        if (this.sortableTable.getSelectedRow() != -1) {
            canEnableActionButton = true;
        }
        this.actionButton.setEnabled(canEnableActionButton);
    }

    private void updateChosenFile(ClientFile clientFile) {
        if (clientFile.equals(this.currentFile)) {
            return;
        }
        this.currentFile = clientFile;
        this.tableModel.clear();
        try {
            this.loadDataFromFile(clientFile);
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.window, this.windowTitle, LNG.get((String)"IAS_IMPORT_USERS_LOAD_DATA_FAILED"));
            e.printStackTrace();
            return;
        }
        this.filePath.setText(this.currentFile.getStringPath());
        this.updateActionButton();
    }

    private void updateUser(User currentUser, UserInfo newUserInfo) throws Exception {
        List<Object> permissionList = new ArrayList();
        List<Object> roleList = new ArrayList();
        permissionList = this.merge((Object[])currentUser.getUserInfo().getAttribute("permissionIds"), (Object[])newUserInfo.getAttribute("permissionIds"));
        roleList = this.merge((Object[])currentUser.getUserInfo().getAttribute("roleIds"), (Object[])newUserInfo.getAttribute("roleIds"));
        UserInfo userInfo = currentUser.getUserInfo();
        userInfo.setAttribute("login", newUserInfo.getAttribute("login"));
        userInfo.setAttribute("name", newUserInfo.getAttribute("name"));
        userInfo.setAttribute("emails", newUserInfo.getAttribute("emails"));
        userInfo.setAttribute("permissionIds", (Object)permissionList.toArray());
        userInfo.setAttribute("roleIds", (Object)roleList.toArray());
        userInfo.setAttribute("unId", newUserInfo.getAttribute("unId"));
        User.modifyUser((Object)currentUser.getId(), (UserInfo)userInfo);
    }

    public ImportUsersDialog(Window owner) {
        this.owner = owner;
        this.windowTitle = LNG.get((String)"IAS_IMPORT_USERS_TITLE");
        this.window = new DesktopComponentDialog(owner, this.windowTitle);
        this.window.center(owner);
        this.contentPane = this.window.getContentPane();
        this.defaultUserInfo = new UserInfo();
        this.userRoleDefinitionDialog = new UserRoleDefinitionDialog(this.window, this.defaultUserInfo, true);
        this.userPermissionDefinitionDialog = new UserPermissionDefinitionDialog(this.window, this.defaultUserInfo, true);
    }

    private static enum ImportResults {
        ALL_IMPORTED,
        SOME_IMPORTED,
        NONE_IMPORTED;

    }

    private class ImportedUserDialog {
        private DesktopComponentDialog dialog;
        private Window dialogOwner;

        private JButton createCloseButton() {
            JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evento) {
                    ImportedUserDialog.this.dialog.close();
                }
            });
            return closeButton;
        }

        private void createDialog(List<String> insertedList, List<String> editedList, List<String> discartedList) {
            this.dialog = new DesktopComponentDialog(this.dialogOwner);
            this.dialog.setTitle(LNG.get((String)"IAS_IMPORT_RESULT"));
            this.dialog.setDefaultCloseOperation(2);
            String insText = LNG.get((String)"IAS_INSERTED");
            JPanel insertedJList = this.createWidgetFromLoginList(insertedList, insText);
            String edtText = LNG.get((String)"IAS_EDITED");
            JPanel editedJList = this.createWidgetFromLoginList(editedList, edtText);
            String dscText = LNG.get((String)"IAS_DISCARTED");
            JPanel discartedJList = this.createWidgetFromLoginList(discartedList, dscText);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)insertedJList, new GBC(0, 0).both().center());
            panel.add((Component)editedJList, new GBC(1, 0).both().center());
            panel.add((Component)discartedJList, new GBC(2, 0).both().center());
            panel.add((Component)this.createCloseButton(), new GBC(0, 1).width(3).center().insets(10, 0, 10, 0));
            this.dialog.getContentPane().add(panel);
        }

        private JPanel createWidgetFromLoginList(List<String> logins, String title) {
            JPanel panel = new JPanel();
            JLabel label = new JLabel(title);
            JTextArea textArea = new JTextArea();
            textArea.setFont(new Font("Monospaced", 0, 12));
            StringBuffer buffer = new StringBuffer();
            for (String login : logins) {
                buffer.append(login + "\n");
            }
            String text = buffer.toString();
            textArea.setText(text);
            textArea.setCaretPosition(0);
            JScrollPane jScrollPane = new JScrollPane(textArea);
            textArea.setMinimumSize(new Dimension(100, 50));
            textArea.setPreferredSize(new Dimension(200, 150));
            textArea.setEditable(false);
            textArea.setBackground(panel.getBackground());
            panel.setLayout(new BorderLayout());
            panel.add((Component)label, "North");
            panel.add((Component)jScrollPane, "Center");
            int d = 3;
            panel.setBorder(BorderFactory.createEmptyBorder(6, 3, 3, 3));
            return panel;
        }

        public void showDialog() {
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(ImportUsersDialog.this.owner);
            this.dialog.setVisible(true);
        }

        public ImportedUserDialog(Window owner, List<String> insertedList, List<String> editedList, List<String> discartedList) {
            if (insertedList != null && editedList != null && discartedList != null) {
                this.dialogOwner = owner;
                this.createDialog(insertedList, editedList, discartedList);
            }
        }
    }
}

