/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.ManagerPanel;
import csbase.client.ias.UserGroupInfoDialog;
import csbase.client.remote.srvproxies.UserGroupProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.SwingObserverWrapper;
import csbase.logic.UserGroup;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class UserGroupManagerPanel
extends ManagerPanel {
    protected JFrame parent;
    private static final int debug = 0;

    @Override
    public void beforeClose() {
        UserGroup.deleteObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void add() {
        new UserGroupInfoDialog(this.parent);
    }

    @Override
    public void modify(Object id) {
        UserGroup userGroup = this.getUserGroup(id);
        if (userGroup == null) {
            return;
        }
        new UserGroupInfoDialog(this.parent, userGroup);
    }

    protected UserGroup getUserGroup(Object id) {
        UserGroup userGroup = UserGroupProxy.getUserGroup(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_USERGROUPMGR_WAITING_USERGROUP"), id);
        if (userGroup == null) {
            this.displayError(LNG.get((String)"IAS_USERGROUPMGR_USERGROUP_NOT_FOUND"));
        }
        return userGroup;
    }

    @Override
    public void delete(Object id) {
        UserGroup userGroup = this.getUserGroup(id);
        if (userGroup == null) {
            return;
        }
        String userGroupName = userGroup.getName();
        int res = StandardDialogs.showYesNoDialog((Component)this.parent, (String)this.parent.getTitle(), (Object)MessageFormat.format(LNG.get((String)"IAS_USERGROUPMGR_USERGROUP_REMOVAL_CONFIRMATION"), userGroupName));
        if (res == 0) {
            UserGroupProxy.deleteUserGroup(this.parent, this.parent.getTitle(), MessageFormat.format(LNG.get((String)"IAS_USERGROUPMGR_WAITING_REMOVE_USERGROUP"), userGroupName), userGroup.getId());
        }
    }

    protected void displayMessage(String title, String message) {
        StandardDialogs.showInfoDialog((Component)this.parent, (String)title, (Object)message);
    }

    protected void displayError(String message) {
        StandardErrorDialogs.showErrorDialog((Window)this.parent, this.parent.getTitle(), message);
    }

    public UserGroupManagerPanel(JFrame parent) {
        this.parent = parent;
        Vector<Object> userGroups = UserGroupProxy.getAllUserGroups(parent, parent.getTitle(), LNG.get((String)"IAS_WAITING_ADMIN_DATA"));
        if (userGroups == null) {
            userGroups = new Vector();
        }
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                UserGroup userGroup = (UserGroup)item;
                if (userGroup == null) {
                    return null;
                }
                return new Object[]{userGroup.getId(), userGroup.getName(), userGroup.getDesc()};
            }

            public String[] getColumnNames() {
                return new String[]{null, LNG.get((String)"IAS_USERGROUP"), LNG.get((String)"IAS_USERGROUP_DESCRIPTION")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{Object.class, String.class, String.class};
            }
        };
        ObjectTableModel model = new ObjectTableModel(userGroups, (ObjectTableProvider)provider);
        Comparator[] comparators = new Comparator[]{null, ClientUtilities.getStringComparatorIgnoreCase(), ClientUtilities.getStringComparatorIgnoreCase()};
        this.make((TableModel)model, comparators, false);
        UserGroup.addObserver((Observer)new SwingObserverWrapper(this));
    }
}

