/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.tasks;

import csbase.client.project.tasks.CoreTask;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.Window;
import java.rmi.RemoteException;

public class CreateFileTask
extends CoreTask<ClientProjectFile> {
    private CommonClientProject clientProject;
    private ClientProjectFile parent;
    private String fileName;
    private String fileType;
    private ErrorCode errorCode = ErrorCode.NOT_EXECUTED;

    public CreateFileTask(CommonClientProject clientProject, ClientProjectFile parent, String fileName, String fileType) {
        this.clientProject = clientProject;
        this.parent = parent;
        this.fileName = fileName;
        this.fileType = fileType;
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof RemoteException) {
            super.handleError(error);
            this.errorCode = ErrorCode.RMI_FAILURE;
        } else if (error instanceof CSBaseRuntimeException) {
            super.handleError(error);
            this.errorCode = ErrorCode.UNKNOWN;
        } else {
            this.errorCode = ErrorCode.UNKNOWN;
        }
        this.setResult(null);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    protected void performTask() throws Exception {
        ClientProjectFile newFile = this.clientProject.createAndWaitForFile(this.parent, this.fileName, this.fileType);
        this.setResult(newFile);
        this.errorCode = ErrorCode.NO_ERROR;
    }

    public static final ClientProjectFile runTask(CommonClientProject clientProject, ClientProjectFile parent, String fileName, String fileType) {
        ClientProjectFile file = CreateFileTask.runTask(null, clientProject, parent, fileName, fileType);
        return file;
    }

    public static final ClientProjectFile runTask(Window window, CommonClientProject clientProject, ClientProjectFile parent, String fileName, String fileType) {
        CreateFileTask task = new CreateFileTask(clientProject, parent, fileName, fileType);
        Object[] args = new Object[]{fileName};
        boolean hasResult = task.execute(window, args);
        if (!hasResult) {
            return null;
        }
        ClientProjectFile file = (ClientProjectFile)task.getResult();
        return file;
    }

    public static enum ErrorCode {
        NO_ERROR,
        NOT_EXECUTED,
        RMI_FAILURE,
        UNKNOWN;

    }
}

