/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.filters;

import csbase.client.project.ClientProjectFileType;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.core.lng.LNG;

public class ClientFileMultipleTypesFilter
implements ClientFileFilterInterface {
    private final List<String> types = new ArrayList<String>();
    private final ImageIcon completeIcon;

    @Override
    public boolean accept(ClientFile file) {
        if (file.isDirectory()) {
            return true;
        }
        for (String type : this.types) {
            if (!file.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        String sufixes = "";
        for (String type : this.types) {
            ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
            List extensions = fileType.getExtensions();
            String extSufix = "(";
            for (String ext : extensions) {
                extSufix = extSufix + " *." + ext + " ";
            }
            extSufix = extSufix + ")";
            sufixes = sufixes + " " + extSufix;
        }
        String className = this.getClass().getSimpleName();
        String label = LNG.get((String)(className + ".description"));
        return ": " + label + " - " + sufixes;
    }

    @Override
    public ImageIcon getImageIcon() {
        return this.completeIcon;
    }

    private ImageIcon buildIcon() {
        ClientProjectFileType firstType = ClientProjectFileType.getFileType(this.types.get(0));
        ImageIcon firstIcon = firstType.getBaseIcon();
        int firstWidth = firstIcon.getIconWidth();
        int h = firstIcon.getIconHeight();
        int gap = 2;
        int numTypes = this.types.size();
        int w = numTypes * firstWidth + (numTypes - 1) * 2;
        BufferedImage buffImg = new BufferedImage(w, h, 2);
        Graphics2D g = buffImg.createGraphics();
        int x = 0;
        for (String type : this.types) {
            ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
            ImageIcon icon = fileType.getBaseIcon();
            g.drawImage(icon.getImage(), x, 0, null);
            x = x + 2 + firstWidth;
        }
        g.dispose();
        ImageIcon imageIcon = new ImageIcon(buffImg);
        return imageIcon;
    }

    public ClientFileMultipleTypesFilter(String[] types) {
        this(Arrays.asList(types));
    }

    public ClientFileMultipleTypesFilter(Collection<String> types) {
        this.types.addAll(types);
        this.completeIcon = this.buildIcon();
        Collections.unmodifiableList(this.types);
    }

    @Override
    public ProjectFileType inferFileType() {
        return null;
    }
}

