/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import csbase.client.util.gui.CardsList;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class CardPanel
extends JPanel {
    private final CardLayout cardLayout;
    private CardsList cardsList;
    boolean dynamicVSize;
    boolean dynamicHSize;

    public CardPanel() {
        this(false, false);
    }

    public CardPanel(boolean dynamicVSize, boolean dynamicHSize) {
        this.dynamicVSize = dynamicVSize;
        this.dynamicHSize = dynamicHSize;
        this.cardLayout = this.initializeCardLayout();
        super.setLayout(this.cardLayout);
        this.cardsList = new CardsList();
    }

    private CardLayout initializeCardLayout() {
        return new CardLayout(){

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Component comp;
                if (!CardPanel.this.dynamicVSize && !CardPanel.this.dynamicHSize) {
                    return super.preferredLayoutSize(parent);
                }
                Dimension d = new Dimension();
                if (!CardPanel.this.dynamicVSize || !CardPanel.this.dynamicHSize) {
                    d = super.preferredLayoutSize(parent);
                }
                if ((comp = CardPanel.this.getCurrentCard()) == null) {
                    return new Dimension(0, 0);
                }
                int h = CardPanel.this.dynamicVSize ? comp.getPreferredSize().height : d.height;
                int w = CardPanel.this.dynamicHSize ? comp.getPreferredSize().width : d.width;
                Insets insets = parent.getInsets();
                return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
            }
        };
    }

    public Component getCurrentCard() {
        return this.cardsList.getCurrentCard();
    }

    public String getCurrentCardName() {
        Component comp = this.cardsList.getCurrentCard();
        return this.cardsList.getCardName(comp);
    }

    public Component show(String name) {
        Component comp = this.cardsList.updateCurrentCard(name);
        if (comp != null) {
            this.cardLayout.show(this, name);
            return this.getCurrentCard();
        }
        return null;
    }

    public boolean show(Component comp) {
        String name = this.cardsList.getCardName(comp);
        if (name != null) {
            this.cardLayout.show(this, name);
            this.cardsList.updateCurrentCard(name);
            return true;
        }
        return false;
    }

    @Override
    public void add(Component comp, Object name) {
        this.add(comp, name, -1);
    }

    @Override
    public Component add(Component comp) {
        return this.add(comp, -1);
    }

    @Override
    public Component add(Component comp, int index) {
        String name = this.cardsList.add(comp, index);
        if (name != null) {
            super.add(comp, name, index);
            return comp;
        }
        return null;
    }

    @Override
    public void add(Component comp, Object name, int index) {
        if (name instanceof String && this.cardsList.add((String)name, comp, index)) {
            super.add(comp, name, index);
            return;
        }
        this.add(comp, index);
    }

    public void remove(String name) {
        Component comp = this.cardsList.getComponentForCardName(name);
        if (comp != null) {
            this.remove(comp);
        }
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        this.cardsList.remove(comp);
    }

    public Component next() {
        Component comp = this.cardsList.getNextCard();
        this.show(comp);
        return comp;
    }

    public Component previous() {
        Component comp = this.cardsList.getPreviousCard();
        this.show(comp);
        return comp;
    }

    public Component first() {
        Component comp = this.cardsList.getFirstCard();
        this.show(comp);
        return comp;
    }

    public Component last() {
        Component comp = this.cardsList.getLastCard();
        this.show(comp);
        return comp;
    }

    public boolean has(String name) {
        return this.cardsList.getComponentForCardName(name) != null;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }
}

