/*
 * $Id:$
 */

package csbase.client.algorithms.parameters;

import java.awt.Window;

import javax.swing.JComponent;
import javax.swing.JTextField;

import csbase.logic.algorithms.parameters.DoubleParameter;

/**
 * Viso para o {@link DoubleParameter Parmetro do Tipo Real}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class DoubleParameterView extends SimpleParameterView<Double> {

  /**
   * Cria a viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro que  manipulador por esta viso (No aceita
   *        {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public DoubleParameterView(Window window, DoubleParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro que  manipulador por esta viso (No aceita
   *        {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public DoubleParameterView(DoubleParameter parameter, Mode mode) {
    super(parameter, mode);
    updateCapabilityView();
    updateVisibilyView();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DoubleParameter getParameter() {
    return (DoubleParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createConfigurationComponent(Object... componentArgs) {
    return new DoubleConfigurationParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createReportComponent(Object... componentArgs) {
    return new DoubleReportParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void updateViewContents() {
    ((IDoubleParameterComponent) getComponent()).updateViewContents();
  }

  /**
   * Interface para componente Double
   *
   * @author Tecgraf
   */
  private interface IDoubleParameterComponent {
    /**
     * Atualiza o contedo exibido pela viso.
     */
    void updateViewContents();
  }

  /**
   * Viso em modo report como texfield.
   *
   * @author Tecgraf
   */
  private final class DoubleReportParameter extends JTextField implements
    IDoubleParameterComponent {

    /**
     * Construtor.
     */
    DoubleReportParameter() {
      setToolTipText(getParameter().getDescription());
      ComponentProperties.setProperties(this, Mode.REPORT, true);
      super.setEditable(false);
      updateViewContents();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      Double value = getParameter().getValue();
      setText(null == value ? " " : value.toString());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setEditable(boolean enable) {
      // Nesse modo o parmetro no pode ser editvel.
    }
  }

  /**
   * Viso como textfield em modo de configurao.
   *
   * @author Tecgraf
   */
  private final class DoubleConfigurationParameter extends DoubleTextField
    implements IDoubleParameterComponent {

    /**
     * Construtor
     */
    DoubleConfigurationParameter() {
      super(new AbstractNumberTextFieldModel<Double>(
        DoubleParameter.ERROR_VALUE) {
        @Override
        public void setValue(Double value) {
          getParameter().setValue(value);
          fireChangedValue();
        }

        @Override
        public Double getValue() {
          return getParameter().getValue();
        }
      });

      setToolTipText(getParameter().getDescription());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      updateView();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean fillVerticalSpace() {
    return false;
  }
}
