package csbase.client.algorithms.parameters;

import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.TextFieldCellViewFactory;
import csbase.logic.algorithms.parameters.TextColumn;

/**
 * Viso para {@link TextColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class TextColumnView extends
  AbstractTableColumnView<String, TextColumn> {
  /**
   * Cria a viso.
   *
   * @param tableView A viso da tabela (No aceita {@code null}).
   * @param column A coluna (No aceita {@code null}).
   */
  public TextColumnView(TableParameterView tableView, TextColumn column) {
    super(tableView, column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CellViewFactory getFactory() {
    return new TextFieldCellViewFactory();
  }
}
