package csbase.client.algorithms.validation;

import java.rmi.RemoteException;

import csbase.logic.algorithms.validation.ValidationMode;

/**
 * Define a interface do validador de uma viso.
 */
public interface ViewValidator {

  /**
   * Validador os valores atuais dos parmetros.
   * 
   * @param mode Modo de validao ({@link ValidationMode#FULL} ou
   *        {@link ValidationMode#ALLOW_EMPY_VALUES}).
   * 
   * @return o resultado da validao.
   * 
   * @throws RemoteException em caso de erro na comunicao com servidor.
   */
  public abstract ViewValidationResult validate(ValidationMode mode)
    throws RemoteException;

  /**
   * Indica na viso o resultado da validao.
   * 
   * @param result o resultado da validao.
   * 
   * @return verdadeiro se o resultado foi mostrado ou falso, caso contrrio.
   */
  public boolean highlightValidationResult(ViewValidationResult result);

}
