package csbase.client.applicationmanager.resourcehelpers;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.version.VersionNumber;
import tecgraf.javautils.version.VersionNumberFinder;
import csbase.client.applications.Application;

/**
 * Buscador de resource de verso.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <T> Classe da aplicao.
 */
final public class ApplicationResourceVersionFinder<T extends Application>
  implements VersionNumberFinder {

  /**
   * Helper
   */
  final private ApplicationResourceHelper<T> helper;

  /**
   * Tag
   */
  final private String tag;

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean hasVersionNumber(VersionNumber version) {
    final String fileName = helper.getVersionedFileName(tag, version);
    final String urlPrefix = helper.getResourceURLPrefix();
    InputStream stream = null;
    try {
      final URL url = new URL(urlPrefix + fileName);
      final Object content = url.getContent();
      return content != null;
    }
    catch (MalformedURLException e) {
      return false;
    }
    catch (IOException e) {
      return false;
    }
    finally {
      FileUtils.close(stream);
    }
  }

  /**
   * Construtor
   * 
   * @param helper helper
   * @param tag tag
   */
  public ApplicationResourceVersionFinder(ApplicationResourceHelper<T> helper,
    final String tag) {
    this.helper = helper;
    this.tag = tag;
  }
}
