/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.algorithmsmanager.versiontree.Mode;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Decorador para aes de ns da rvore de algoritmo.<br>
 *         Caso a rvore esteja em modo {@link Mode#WIZARD}, quando esta ao
 *         for chamada, uma janela ir aparecer para o usurio indicando que a
 *         verso da rvore poder sofrer alteraes e dando a opo a ele de
 *         prosseguir ou cancelar com a ao decorada.
 */
public class VersionWarningActionDecorator extends
  AbstractVersionTreeNodeAction {

  private AbstractVersionTreeNodeAction action;

  /**
   * COnstrutor.
   * 
   * @param action A ao a ser decorada.
   */
  public VersionWarningActionDecorator(AbstractVersionTreeNodeAction action) {
    super(action.getTree(), action.getName());

    this.action = action;

    setEnabled(action.isEnabled());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    if (getTree().getMode() == Mode.WIZARD) {
      if (!warningModifyVersion()) {
        return;
      }
    }
    action.actionPerformed(e);
  }

  /**
   * Exibe um dilogo alertando ao usurio que modificar uma verso de algoritmo
   *  perigoso e d a opo para ele abortar a operao.
   * 
   * @return {@code true} se o usurio desejar continuar ou {@code false} caso
   *         contrrio.
   */
  protected boolean warningModifyVersion() {
    String message = LNG.get("algomanager.warning.modify.version.message");
    String title = LNG.get("algomanager.warning.modify.version.title");
    String continueMessage = LNG.get("algomanager.option.continue");
    String cancelMessage = LNG.get("algomanager.option.cancel");
    int continueIndex = 0;
    int cancelIndex = 1;
    int optionsCount = 2;
    Object[] options = new Object[optionsCount];
    options[continueIndex] = continueMessage;
    options[cancelIndex] = cancelMessage;
    int option =
      StandardDialogs.showOptionDialog(action.getWindow(), title, message,
        options);
    if (option == continueIndex) {
      return true;
    }
    else if (option == cancelIndex) {
      return false;
    }
    else {
      String errorMessage =
        String.format("Opo invlida. Opo: %d.\n", option);
      throw new IllegalStateException(errorMessage);
    }
  }
}
