/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Contrato de uma fonte de objetos passveis de exportao atravs do
 *         {@link VersionTreeTransferHandler}.
 */
public interface ITransferableSource {

  /**
   * Obtm o objeto a ser exportado.
   * 
   * @return objeto a ser exportado.
   */
  Serializable getData();

  /**
   * Obtm o {@link DataFlavor} do objeto.<br>
   * Este objeto s poder ser exportado para um {@Link
   * ITransferableTarget} que aceitar este {@link DataFlavor}.
   * 
   * @return o {@link DataFlavor} do objeto.
   */
  DataFlavor getDataFlavor();
}
