/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor;

import javax.swing.JTabbedPane;

/**
 * Se implementado por uma aba de um {@link JTabbedPane} que tenha como ouvinte
 * um {@link JTabbedPaneSelectionListener}, essa aba ser informada quando for
 * selecionada ou desselecionada.
 * 
 * @author Tecgraf / PUC-Rio
 */
public interface ISelectionListenerTab {

  /**
   * Trata o evento de (des)seleo da aba.
   * 
   * @param selected <tt>true</tt> se a aba foi selecionada ou <tt>false</tt>
   *        caso ela tenha perdido a seleo.
   */
  void onSelectionChanged(boolean selected);
}
