/*
 * $Id: OpenLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import java.util.List;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.csvviewer.CSVViewer;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil.OperationResult;
import csbase.logic.ClientFile;

/**
 * Pede para a aplicao que detm o painel de controle por um novo arquivo de
 * csv e o abre no painel de csv.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class OpenCSVAction extends AbstractCSVAction {

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  public OpenCSVAction(CSVViewer application) {
    super(application, ApplicationImages.ICON_OPEN_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    CSVViewer application = getApplication();
    List<String> fileTypes = application.getFileTypes();
    OperationResult result =
      ClientProjectFileChooserUtil.browseSingleFileInOpenMode(application,
        fileTypes, true);
    if (result == null) {
      return;
    }
    final ClientFile file = result.getClientProjectFile();
    if (file == null) {
      return;
    }
    application.openFile(file);
  }
}
