/*
 * $Id: EventRenderer.java 109074 2010-08-13 21:56:39Z clinio $
 */

package csbase.client.applications.desktoplauncher.panels.eventpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import csbase.client.Client;
import csbase.client.applications.desktoplauncher.DesktopLauncherEvent;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventDirection;
import csbase.client.applications.desktoplauncher.DesktopLauncherUI;

/**
 * Renderizador da tabela de requisies
 * 
 * @author Tecgraf/PUC-Rio
 */
class EventRenderer implements TableCellRenderer {

  /**
   * Renderer default.
   */
  public static final DefaultTableCellRenderer DEFAULT_RENDERER =
    new DefaultTableCellRenderer();

  /**
   * Font default.
   */
  final private Font DEFAULT_FONT = DEFAULT_RENDERER.getFont();
  
  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    Component renderer =
      DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, row, column);
    final JLabel label = ((JLabel) renderer);
    label.setOpaque(true);
    label.setIcon(null);
    label.setHorizontalAlignment(SwingConstants.LEFT);
    label.setForeground(Color.black);
    label.setFont(DEFAULT_FONT);
    
    final Client client = Client.getInstance();
    final String myId = client.getClientInstanceId();
    
    final DesktopLauncherEvent event = (DesktopLauncherEvent) value;
    final String otherId = event.getOtherId();
    if (otherId != null && otherId.equals(myId)) {
      label.setForeground(Color.gray);
      label.setFont(DEFAULT_FONT.deriveFont(Font.ITALIC));
    }

    if (column == 0) {
      final Date date = event.getDate();
      label.setHorizontalAlignment(SwingConstants.LEFT);
      final String text = DesktopLauncherUI.formatDate(date);
      label.setText(text);
      label.setIcon(null);
    }
    else if (column == 1) {
      final DesktopLauncherEventDirection direction = event.getDirection();
      label.setHorizontalAlignment(SwingConstants.CENTER);
      label.setText(null);
      final ImageIcon icon = DesktopLauncherUI.getDirectionIcon(direction);
      label.setIcon(icon);
    }
    else if (column == 2) {
      final boolean treated = event.isTreated();
      label.setHorizontalAlignment(SwingConstants.CENTER);
      label.setText(null);
      final ImageIcon icon = DesktopLauncherUI.getTreatedIcon(treated);
      label.setIcon(icon);
    }
    else if (column == 3) {
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(otherId);
      label.setIcon(null);
    }
    else if (column == 4) {
      final String typeName = event.getType();
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(typeName);
      label.setIcon(null);
    }
    else if (column == 5) {
      final String className = event.getClassName();
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(className);
      label.setIcon(null);
    }
    else if (column == 6) {
      final String valueText = event.getValueText();
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(valueText);
      label.setIcon(null);
    }
    return label;
  }

  /**
   * Construtor
   */
  public EventRenderer() {
  }
}
