/*
 * $Id: LogPanel.java 112434 2010-11-10 18:06:20Z clinio $
 */
package csbase.client.applications.desktoplauncher.panels.logpanel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Date;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.applications.desktoplauncher.DesktopLauncherUI;

/**
 * Painel de log.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class LogPanel extends ApplicationComponentPanel<DesktopLauncher> {
  /**
   * rea de texto.
   */
  final private JTextArea textArea = new JTextArea();

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public LogPanel(final DesktopLauncher application) {
    super(application);

    textArea.setEditable(false);
    final Font font = new Font(Font.MONOSPACED, Font.PLAIN, 12);
    textArea.setFont(font);

    setLayout(new BorderLayout());
    add(new JScrollPane(textArea), BorderLayout.CENTER);
    textArea.setMinimumSize(new Dimension(400, 250));
  }

  /**
   * Adio de texto.
   * 
   * @param text texto.
   */
  final public void appendText(String text) {
    final String msg;
    if (text == null) {
      msg = "\n\n";
    }
    else {
      final Date now = new Date();
      final String dateStr = DesktopLauncherUI.formatDate(now);
      final String fmt = "[%s] - %s\n";
      msg = String.format(fmt, dateStr, text);
    }
    textArea.append(msg);
    textArea.setCaretPosition(textArea.getText().length());
  }

  /**
   * Limpeza do log.
   */
  final public void clear() {
    textArea.setText(null);
  }
}
