/*
 * $Id:$
 */

package csbase.client.applications.diskmonitor.actions;

import java.awt.event.KeyEvent;

import javax.swing.JComponent;
import javax.swing.KeyStroke;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.diskmonitor.DiskMonitor;
import csbase.client.applications.diskmonitor.actions.core.DiskMonitorAction;

/**
 * Ao de refresh imediato.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DiskMonitorRefreshAction extends DiskMonitorAction {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public DiskMonitorRefreshAction(DiskMonitor application) {
    super(application, ApplicationImages.ICON_REFRESH_16);
    final KeyStroke keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0);
    putValue(ACCELERATOR_KEY, keyStroke);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent cmp) {
    final DiskMonitor application = getApplication();
    application.refresh();
  }

}
