/*
 * $Id: FileExchangerPanel.java 146656 2013-11-07 17:13:39Z mjulia $
 */

package csbase.client.applications.fileexchanger.panels.core;

import javax.swing.JPanel;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.FileExchangerUI;

/**
 * Painel da aplicao
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileExchangerPanel extends JPanel {

  /**
   * A aplicao
   */
  final private FileExchanger fileExchanger;

  /**
   * Consulta  aplicao.
   * 
   * @return a aplicao
   */
  final public FileExchanger getFileExchanger() {
    return fileExchanger;
  }

  /**
   * Consulta de um texto de internacionalizao
   * 
   * @param tag o tag de internacionalizao
   * @return o texto.
   */
  final protected String getClassString(final String tag) {
    final Class<?> theClass = this.getClass();
    return FileExchangerUI.getClassString(theClass, tag);
  }

  /**
   * Consulta de um texto de internacionalizao
   * 
   * @param tag o tag de internacionalizao
   * @return o texto.
   */
  final protected String getString(final String tag) {
    return FileExchangerUI.getString(tag);
  }

  /**
   * Construtor
   * 
   * @param fileExchanger a aplicao
   */
  public FileExchangerPanel(final FileExchanger fileExchanger) {
    this.fileExchanger = fileExchanger;
  }
}
