package csbase.client.applications.flowapplication;

import csbase.client.preferences.annotations.ReadWrite;
import csbase.client.preferences.annotations.Value;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.types.PVBoolean;

/**
 * Preferncias do construtor de fluxos.
 */
public enum FlowApplicationPref implements PreferenceDefinition {

  /**
   * Define se as verses devem ser mostradaa na rvore de algortmos da
   * aplicao.
   */
  @ReadWrite
  @Value(type = PVBoolean.class, defaultValue = "false")
  SHOW_VERSION_IN_TREE,

  /**
   * Define se o nmero da verso deve ser mostrada nos algoritmos na rea de
   * trabalho da aplicao.
   */
  @ReadWrite
  @Value(type = PVBoolean.class, defaultValue = "false")
  SHOW_VERSION_IN_WORKSPACE,

  /**
   * Define se ligaes devem ser criadas automaticamente para novos algoritmos
   * adicionados ao fluxo.
   */
  @ReadWrite
  @Value(type = PVBoolean.class, defaultValue = "true")
  AUTO_CREATE_LINKS,

  /**
   * Define se o usurio dever salvar o fluxo sempre antes de executar.
   */
  @ReadWrite
  @Value(type = PVBoolean.class, defaultValue = "false")
  SAVE_GRAPH_BEFORE_EXECUTE,

}
