package csbase.client.applications.flowapplication;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

import csbase.logic.algorithms.flows.Flow;

/**
 * Informaes de um fluxo, transferveis via clipboard.
 */
public final class FlowTransferable implements Transferable {

  /**
   * Informaes do fluxo.
   */
  private final Flow flow;

  /**
   * Flavor
   */
  public static final DataFlavor DATA_FLAVOR = new DataFlavor(Flow.class,
    Flow.class.getName());

  /**
   * Construtor
   * 
   * @param flow o fluxo.
   */
  public FlowTransferable(Flow flow) {
    if (flow == null) {
      throw new IllegalArgumentException("O parmetro graph est nulo.");
    }
    this.flow = flow;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataFlavor[] getTransferDataFlavors() {
    return new DataFlavor[] { DATA_FLAVOR };
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isDataFlavorSupported(final DataFlavor flavor) {
    if (DATA_FLAVOR.equals(flavor)) {
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Flow getTransferData(final DataFlavor flavor)
    throws UnsupportedFlavorException {
    if (!isDataFlavorSupported(flavor)) {
      throw new UnsupportedFlavorException(flavor);
    }
    return this.flow;
  }
}
