package csbase.client.applications.flowapplication;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/**
 * <p>Rubber band.</p>
 *  <p>A rubber band  uma caixa envolvente utilizada para selecionar
 * mltiplos elementos de uma s vez.</p>
 *
 * @author lmoreira
 */
public final class RubberBand {
  /** Cor da caixa. */
  private static final Color COLOR = new Color(63, 178, 255);

  /** Trao da caixa. */
  private static final Stroke STROKE =
    new BasicStroke(
      1f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER, 1f,
      new float[] { 4f, 3f }, 4f);

  /** Ponto final. */
  private Point2D endPoint;

  /** Ponto inicial. */
  private Point2D startPoint;

/**
   * <p>
   * Cria uma rubber band.
   * </p>
   * 
   * <p>
   * A caixa inicialmente tem tamanho 0x0.
   * </p>
   *
   * @param startPoint O ponto inicial.
   */
  public RubberBand(Point2D startPoint) {
    this.startPoint = (Point2D)startPoint.clone();
    this.endPoint = this.startPoint;
  }

  /**
   * Obtm a caixa envolvente da rubber band.
   *
   * @return A caixa envolvente.
   */
  public Rectangle2D getBounds() {
    Rectangle2D bounds = new Rectangle();
    bounds.setFrameFromDiagonal(this.startPoint, this.endPoint);
    return bounds;
  }

  /**
   * Desenha esta caixa no <code>Graphics2D</code> passado.
   *
   * @param g O <code>Graphics2D</code>.
   */
  public void paint(Graphics2D g) {
    g.setColor(COLOR);
    g.setStroke(STROKE);
    Rectangle2D rectangle = getBounds();
    GeneralPath path = new GeneralPath();
    path.moveTo((float)rectangle.getMinX(), (float)rectangle.getMinY());
    path.lineTo((float)rectangle.getMinX(), (float)rectangle.getMaxY());
    path.lineTo((float)rectangle.getMaxX(), (float)rectangle.getMaxY());
    path.lineTo((float)rectangle.getMaxX(), (float)rectangle.getMinY());
    path.closePath();
    g.draw(path);
  }

  /**
   * Mofica o ponto final da caixa.
   *
   * @param endPoint O ponto final.
   */
  public void setPoint(Point2D endPoint) {
    this.endPoint = (Point2D)endPoint.clone();
  }
}
