package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * Ao de mostrar o painel de configurao de parmetros de um n do grafo.
 */
public final class AskForParameterValuesAction extends FlowApplicationAction {
  /**
   * Cria a ao.
   * 
   * @param app A aplicao.
   */
  public AskForParameterValuesAction(FlowApplication app) {
    super(app, ApplicationImages.ICON_EDITPARAMS_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    getApplication().askForParameterValues();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementParametrized(Graph graph, GraphElement element) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDragged(Graph graph, GraphElement element,
    Point2D startPoint, Point2D endPoint) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDropped(Graph graph, GraphElement element, Point2D point) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(Graph graph, GraphElement element) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    updateAction(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(Graph graph) {
    updateAction(graph);
  }

  /**
   * Habilita a ao caso haja algum n selecionado bem formado no grafo.
   * Desabilita, caso, contrrio,
   * 
   * @param graph O grafo.
   */
  private void updateAction(Graph graph) {
    for (GraphNode node : graph.getNodeCollection()) {
      if (node.isSelected() && node.getAlgorithmConfiguratorView() != null) {
        setEnabled(true);
        return;
      }
    }
    setEnabled(false);
  }
}
