package csbase.client.applications.flowapplication.graph.utils;

import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * Operao de atualizao de verso dos algoritmos dos n de um fluxo.
 * 
 * @author isabella
 */
public class GraphUpdateOperation {

  /**
   * O grafo do fluxo a ser atualizado.
   */
  private Graph graph;

  /**
   * Construtor.
   * 
   * @param graph O grafo do fluxo a ser atualizado.
   */
  public GraphUpdateOperation(Graph graph) {
    if (graph == null) {
      throw new IllegalArgumentException("O parmetro graph est nulo!");
    }
    this.graph = graph;
  }

  /**
   * Determina se existe uma verso mais nova para o algoritmo de algum n de um
   * determinado grafo.
   * 
   * @param graph O grafo.
   * @return Verdadeiro se algum n representa um algoritmo dasatualizado, ou
   *         Falso, caso contrrio
   */
  public static boolean hasNewerVersion(Graph graph) {
    if (graph != null) {
      for (GraphNode node : graph.getNodeCollection()) {
        if (GraphNodeUpdateOperation.hasNewerVersion(node)) {
          return true;
        }
      }
    }
    return false;
  }

  /**
   * Determina se existe uma verso mais nova para o algoritmo de algum n do
   * grafo.
   * 
   * @return Verdadeiro se algum n representa um algoritmo dasatualizado, ou
   *         Falso, caso contrrio
   */
  public boolean hasNewerVersion() {
    return hasNewerVersion(graph);
  }

  /**
   * Atualiza ns que representam algoritmos desatualizados (que tem pelo menos
   * uma verso mais nova disponvel).
   * 
   * @return verdadeiro se a atualizao de todos os ns foi feita com sucesso
   *         ou falso, caso pelo menos uma atualizao tenha falhado.
   */
  public boolean update() {
    boolean result = true;
    for (GraphNode node : graph.getNodeCollection()) {
      GraphNodeUpdateOperation operation = new GraphNodeUpdateOperation(node);
      result = result && operation.update(false);
    }
    return result;
  }

}
