/*
 * $Id: ProjectsManagerScope.java 146656 2013-11-07 17:13:39Z mjulia $
 */

package csbase.client.applications.projectsmanager.models;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;

/**
 * Escopo de projeto
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum ProjectsManagerScope {

  /**
   * Escopo de projeto pblico.
   */
  NOT_APPLICABLE(ApplicationImages.ICON_BLANK_16),

  /**
   * Escopo de projeto pblico.
   */
  PUBLIC(ApplicationImages.ICON_PUBLIC_16),

  /**
   * Escopo de projeto privado.
   */
  PRIVATE(ApplicationImages.ICON_PRIVATE_16),

  /**
   * Escopo de projeto compartilhado.
   */
  SHARED(ApplicationImages.ICON_SHARED_16);

  /**
   * cone do escopo.
   */
  final private ImageIcon icon;

  /**
   * Imagem do escopo.
   * 
   * @return a imagem
   */
  final public ImageIcon getIcon() {
    return icon;
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final private String getClassString(final String tag) {
    return ProjectsManagerUI.getClassString(this.getClass(), tag);
  }

  /**
   * Mtodo de teste de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final private boolean hasString(final String tag) {
    return ProjectsManagerUI.hasClassString(this.getClass(), tag);
  }

  /**
   * @return O identificador deste campo da enumerao.
   */
  public String getDescription() {
    final String tag = this.name() + ".description";
    if (hasString(tag))
      return getClassString(tag);
    return null;
  }

  /**
   * Consulta uma string que sirva de ttulo para o tipo de escopo
   * 
   * @return o ttulo
   */
  final public String getTitle() {
    final String tag = this.name() + ".title";
    if (hasString(tag))
      return getClassString(tag);
    return null;
  }

  /**
   * Construtor
   * 
   * @param icon icone
   */
  private ProjectsManagerScope(final ImageIcon icon) {
    this.icon = icon;
  }

}
