package csbase.client.applications.projectsmanager.proxy;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;

/**
 * Task responsvel por obter o tamanho ocupado por diversos projetos
 * selecionados.
 * 
 * @author jnlopes
 * 
 */
public class MultipleProjectSpaceTask extends ProjectsManagerTask<List<Double>> {

  /**
   * Nomes dos projetos.
   */
  final private List<String> projectsNames;

  /**
   * Logins dos donos de projeto.
   */
  final private List<Object> ownersIds;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao.
   * @param projectsNames nomes dos projetos.
   * @param ownersIds logins dos donos dos projetos.
   */
  public MultipleProjectSpaceTask(final ProjectsManager projectsManager,
    final List<String> projectsNames, final List<Object> ownersIds) {
    super(projectsManager);

    this.projectsNames = projectsNames;
    this.ownersIds = ownersIds;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    final List<Double> projectsSpace = getProjectsSpace();
    setResult(projectsSpace);
  }

  /**
   * Calcula o espao ocupado por uma lista de projetos.
   * 
   * @return Espao ocupado por uma lista de projetos.
   * @throws RemoteException se {@link DiskUsageServiceInterface} o fizer.
   */
  private List<Double> getProjectsSpace() throws RemoteException {
    final List<Double> projectsOccupiedSpace = new ArrayList<Double>();
    final DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;

    for (int i = 0; i < projectsNames.size(); i++) {
      final double usedSpaceForProjectMb =
        dus.getUsedSpaceForProjectMb(ownersIds.get(i), projectsNames.get(i));
      projectsOccupiedSpace.add(usedSpaceForProjectMb);
    }
    return projectsOccupiedSpace;
  }

}
