package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Coluna que exibe o nmero de ns livres de um cluster.<br/>
 * Classificamos um n como 'livre' quando:<br/>
 * 1 - N est vivo; <br/>
 * 2 - O n no possui jobs em execuo.
 * 
 * @author Tecgraf
 */
public class FreeColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public FreeColumn(String id, Boolean visible, IStringProvider stringProvider,
    Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Integer.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {

    int count = 0;
    for (SGAInfo node : obj.getAllInfo()) {
      if (node.getAlive() && node.getNumberOfJobs() == 0) {
        count++;
      }
    }

    return count;
  }

}
